/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentMapper;

public final class ConsumerBeanParamMapper
extends ConsumerArgumentMapper {
    private final String invocationArgumentName;
    private final List<FieldMeta> fields = new ArrayList<FieldMeta>();

    public ConsumerBeanParamMapper(String invocationArgumentName) {
        this.invocationArgumentName = invocationArgumentName;
    }

    public void addField(String invocationArgumentName, Getter<Object, Object> getter) {
        this.fields.add(new FieldMeta(invocationArgumentName, getter));
    }

    @Override
    public void invocationArgumentToSwaggerArguments(SwaggerInvocation swaggerInvocation, Map<String, Object> swaggerArguments, Map<String, Object> invocationArguments) {
        Object consumerArgument = invocationArguments.get(this.invocationArgumentName);
        if (consumerArgument == null) {
            return;
        }
        for (FieldMeta fieldMeta : this.fields) {
            swaggerArguments.put(fieldMeta.swaggerArgumentName, fieldMeta.getter.get(consumerArgument));
        }
    }

    private class FieldMeta {
        String swaggerArgumentName;
        Getter<Object, Object> getter;

        public FieldMeta(String swaggerArgumentName, Getter<Object, Object> getter) {
            this.swaggerArgumentName = swaggerArgumentName;
            this.getter = getter;
        }
    }
}

