/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.tcp;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.vertx.client.tcp.AbstractTcpClientPackage;
import org.apache.servicecomb.foundation.vertx.client.tcp.NetClientWrapper;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpClientConfig;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpData;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpRequest;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpResponseCallback;
import org.apache.servicecomb.foundation.vertx.server.TcpParser;
import org.apache.servicecomb.foundation.vertx.tcp.TcpConnection;
import org.apache.servicecomb.foundation.vertx.tcp.TcpOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClientConnection
extends TcpConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpClientConnection.class);
    private NetClientWrapper netClientWrapper;
    private TcpClientConfig clientConfig;
    private URIEndpointObject endpoint;
    private InetSocketAddress socketAddress;
    private boolean localSupportLogin = false;
    private boolean remoteSupportLogin;
    private volatile Status status = Status.DISCONNECTED;
    private Queue<AbstractTcpClientPackage> packageQueue = new ConcurrentLinkedQueue<AbstractTcpClientPackage>();
    private volatile Map<Long, TcpRequest> requestMap = new ConcurrentHashMap<Long, TcpRequest>();

    public TcpClientConnection(Context context, NetClientWrapper netClientWrapper, String strEndpoint) {
        this.setContext(context);
        this.netClientWrapper = netClientWrapper;
        this.endpoint = new URIEndpointObject(strEndpoint);
        this.socketAddress = this.endpoint.getSocketAddress();
        this.remoteSupportLogin = Boolean.parseBoolean(this.endpoint.getFirst("login"));
        this.clientConfig = netClientWrapper.getClientConfig(this.endpoint.isSslEnabled());
    }

    public boolean isLocalSupportLogin() {
        return this.localSupportLogin;
    }

    public TcpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setLocalSupportLogin(boolean localSupportLogin) {
        this.localSupportLogin = localSupportLogin;
    }

    protected TcpOutputStream createLogin() {
        return null;
    }

    protected boolean onLoginResponse(Buffer bodyBuffer) {
        return true;
    }

    public CompletableFuture<TcpData> send(AbstractTcpClientPackage tcpClientPackage) {
        CompletableFuture<TcpData> future = new CompletableFuture<TcpData>();
        this.send(tcpClientPackage, ar -> {
            if (ar.failed()) {
                future.completeExceptionally(ar.cause());
                return;
            }
            future.complete((TcpData)ar.result());
        });
        return future;
    }

    public void send(AbstractTcpClientPackage tcpClientPackage, TcpResponseCallback callback) {
        this.requestMap.put(tcpClientPackage.getMsgId(), new TcpRequest(tcpClientPackage.getMsRequestTimeout(), callback));
        if (this.writeToBufferQueue(tcpClientPackage)) {
            return;
        }
        this.context.runOnContext(v -> {
            if (!this.writeToBufferQueue(tcpClientPackage)) {
                this.packageQueue.add(tcpClientPackage);
            }
            if (Status.DISCONNECTED.equals((Object)this.status)) {
                this.connect();
            }
        });
    }

    private boolean writeToBufferQueue(AbstractTcpClientPackage tcpClientPackage) {
        if (Status.WORKING.equals((Object)this.status)) {
            try (TcpOutputStream os = tcpClientPackage.createStream();){
                this.write(os.getByteBuf());
                tcpClientPackage.finishWriteToBuffer();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void writeInContext() {
        this.writePackageInContext();
        super.writeInContext();
    }

    private void writePackageInContext() {
        AbstractTcpClientPackage pkg;
        while ((pkg = this.packageQueue.poll()) != null) {
            TcpOutputStream os = pkg.createStream();
            Throwable throwable = null;
            try {
                Buffer buf = os.getBuffer();
                this.netSocket.write((Object)buf);
                pkg.finishWriteToBuffer();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                os.close();
            }
        }
    }

    @VisibleForTesting
    protected void connect() {
        this.status = Status.CONNECTING;
        LOGGER.info("connecting to address {}", (Object)this.socketAddress.toString());
        this.netClientWrapper.connect(this.endpoint.isSslEnabled(), this.socketAddress.getPort(), this.socketAddress.getHostString(), (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.onConnectSuccess((NetSocket)ar.result());
                return;
            }
            this.onConnectFailed(ar.cause());
        }));
    }

    private void onConnectSuccess(NetSocket socket) {
        LOGGER.info("connected to address {} success in thread {}.", (Object)this.socketAddress.toString(), (Object)Thread.currentThread().getName());
        this.initNetSocket((NetSocketImpl)socket);
        socket.handler((Handler)new TcpParser(this::onReply));
        socket.exceptionHandler(this::onException);
        socket.closeHandler(this::onClosed);
        this.tryLogin();
    }

    private void onClosed(Void v) {
        this.onDisconnected(new IOException("socket closed"));
    }

    private void onException(Throwable e) {
        LOGGER.error("{} disconnected from {}, in thread {}, cause {}", new Object[]{this.netSocket.localAddress().toString(), this.socketAddress.toString(), Thread.currentThread().getName(), e.getMessage()});
    }

    private void onDisconnected(Throwable e) {
        this.status = Status.DISCONNECTED;
        LOGGER.error("{} disconnected from {}, in thread {}, cause {}", new Object[]{this.netSocket.localAddress().toString(), this.socketAddress.toString(), Thread.currentThread().getName(), e.getMessage()});
        this.clearCachedRequest(e);
    }

    protected void tryLogin() {
        if (!this.localSupportLogin || !this.remoteSupportLogin) {
            LOGGER.error("local or remote not support login, address={}, localSupportLogin={}, remoteSupportLogin={}.", new Object[]{this.socketAddress.toString(), this.localSupportLogin, this.remoteSupportLogin});
            this.onLoginSuccess();
            return;
        }
        this.status = Status.TRY_LOGIN;
        LOGGER.info("try login to address {}", (Object)this.socketAddress.toString());
        try (TcpOutputStream os = this.createLogin();){
            this.requestMap.put(os.getMsgId(), new TcpRequest(this.clientConfig.getMsLoginTimeout(), this::onLoginResponse));
            this.netSocket.write((Object)os.getBuffer());
        }
    }

    private void onLoginResponse(AsyncResult<TcpData> asyncResult) {
        if (asyncResult.failed()) {
            LOGGER.error("login failed, address {}", (Object)this.socketAddress.toString(), (Object)asyncResult.cause());
            this.netSocket.close();
            return;
        }
        if (!this.onLoginResponse(((TcpData)asyncResult.result()).getBodyBuffer())) {
            LOGGER.error("login failed, address {}", (Object)this.socketAddress.toString());
            this.netSocket.close();
            return;
        }
        LOGGER.info("login success, address {}", (Object)this.socketAddress.toString());
        this.onLoginSuccess();
    }

    private void onLoginSuccess() {
        this.status = Status.WORKING;
        this.writeInContext();
    }

    private void onConnectFailed(Throwable cause) {
        this.status = Status.DISCONNECTED;
        String msg = String.format("connect to address %s failed.", this.socketAddress.toString());
        LOGGER.error(msg, cause);
        this.clearCachedRequest(cause);
    }

    protected void clearCachedRequest(Throwable cause) {
        Map<Long, TcpRequest> oldMap = this.requestMap;
        this.requestMap = new ConcurrentHashMap<Long, TcpRequest>();
        for (TcpRequest request : oldMap.values()) {
            request.onSendError(cause);
        }
        oldMap.clear();
    }

    protected void onReply(long msgId, Buffer headerBuffer, Buffer bodyBuffer) {
        TcpRequest request = this.requestMap.remove(msgId);
        if (request == null) {
            LOGGER.error("Unknown reply msgId {}, waiting count {}", (Object)msgId, (Object)this.requestMap.size());
            return;
        }
        request.onReply(headerBuffer, bodyBuffer);
    }

    public void checkTimeout() {
        for (Map.Entry<Long, TcpRequest> entry : this.requestMap.entrySet()) {
            TcpRequest request = entry.getValue();
            if (!request.isTimeout() || (request = this.requestMap.remove(entry.getKey())) == null) continue;
            String msg = String.format("request timeout, msgId=%d, address=%s", entry.getKey(), this.socketAddress);
            LOGGER.error(msg);
            request.onTimeout(new TimeoutException(msg));
        }
    }

    static enum Status {
        CONNECTING,
        DISCONNECTED,
        TRY_LOGIN,
        WORKING;

    }
}

