/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.config;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import io.vertx.core.http.HttpVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.servicecomb.deployment.Deployment;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceRegistryConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryConfigBuilder.class);
    private boolean ssl;

    ServiceRegistryConfigBuilder() {
    }

    public ServiceRegistryConfig build() {
        return new ServiceRegistryConfig().setHttpVersion(this.getHttpVersion()).setInstances(this.getInstances()).setIpPort(this.getIpPort()).setSsl(this.isSsl()).setClientName("registry").setWatchClientName("registry-watch").setConnectionTimeout(this.getConnectionTimeout()).setIdleConnectionTimeout(this.getIdleConnectionTimeout()).setIdleWatchConnectionTimeout(this.getIdleWatchTimeout()).setRequestTimeout(this.getRequestTimeout()).setHeartBeatRequestTimeout(this.getHeartBeatRequestTimeout()).setHeartbeatInterval(this.getHeartbeatInterval()).setInstancePullInterval(this.getInstancePullInterval()).setRegistryAutoDiscovery(this.isRegistryAutoDiscovery()).setRegistryAutoRefresh(this.isRegistryAutoRefresh()).setResendHeartBeatTimes(this.getResendHeartBeatTimes()).setAlwaysOverrideSchema(this.isAlwaysOverrideSchema()).setIgnoreSwaggerDifference(this.isIgnoreSwaggerDifference()).setPreferIpAddress(this.isPreferIpAddress()).setWatch(this.isWatch()).setRegistryApiVersion(this.getRegistryApiVersion()).setTenantName(this.getTenantName()).setDomainName(this.getDomainName()).setAccessKey(this.getAccessKey()).setSecretKey(this.getSecretKey()).setProxyEnable(this.isProxyEnable()).setProxyHost(this.getProxyHost()).setProxyPort(this.getProxyPort()).setProxyUsername(this.getProxyUsername()).setProxyPasswd(this.getProxyPasswd()).setAuthHeaderProviders(this.getAuthHeaderProviders());
    }

    public HttpVersion getHttpVersion() {
        DynamicStringProperty property = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.service.registry.client.httpVersion", "HTTP_1_1");
        return HttpVersion.valueOf((String)property.get());
    }

    public int getInstances() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.instances", 1);
        int deployInstances = property.get();
        if (deployInstances <= 0) {
            int nAvailableProcessors = Runtime.getRuntime().availableProcessors();
            LOGGER.warn("The property `{}` must be positive integer, fallback to use number of available processors: {}", (Object)"servicecomb.service.registry.client.instances", (Object)nAvailableProcessors);
            return nAvailableProcessors;
        }
        return deployInstances;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public ArrayList<IpPort> getIpPort() {
        List uriList = Objects.requireNonNull(Deployment.getSystemBootStrapInfo((String)"ServiceCenter"), "no sc address found!").getAccessURL();
        ArrayList<IpPort> ipPortList = new ArrayList<IpPort>();
        uriList.forEach(anUriList -> {
            try {
                URI uri = new URI(anUriList.trim());
                this.ssl = "https".equals(uri.getScheme());
                ipPortList.add(NetUtils.parseIpPort((URI)uri));
            }
            catch (Exception e) {
                LOGGER.error("servicecomb.service.registry.address invalid : {}", anUriList, (Object)e);
            }
        });
        return ipPortList;
    }

    public String getTransport() {
        return "rest";
    }

    public int getConnectionTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.connection", 1000);
        int timeout = property.get();
        return timeout < 0 ? 1000 : timeout;
    }

    public int getIdleConnectionTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.idle", 60);
        int timeout = property.get();
        return timeout < 1 ? 60 : timeout;
    }

    public int getIdleWatchTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.watch", 60);
        int timeout = property.get();
        return timeout < 1 ? 60 : timeout;
    }

    public int getRequestTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.request", 30000);
        int timeout = property.get();
        return timeout < 1 ? 30000 : timeout;
    }

    public int getHeartBeatRequestTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.heartbeat", 3000);
        int timeout = property.get();
        return timeout < 1 ? 3000 : timeout;
    }

    public int getHeartbeatInterval() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.instance.healthCheck.interval", 30);
        int interval = property.get();
        return interval < 0 ? 30 : interval;
    }

    public int getInstancePullInterval() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.instance.pull.interval", 30);
        int interval = property.get();
        return interval < 0 ? 30 : interval;
    }

    public boolean isRegistryAutoDiscovery() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.autodiscovery", false);
        return property.get();
    }

    public boolean isRegistryAutoRefresh() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.autoRefresh", false);
        return property.get();
    }

    public int getResendHeartBeatTimes() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.instance.healthCheck.times", 3);
        int times = property.get();
        return times < 0 ? 3 : times;
    }

    public boolean isAlwaysOverrideSchema() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.alwaysOverrideSchema", false);
        return property.get();
    }

    public boolean isIgnoreSwaggerDifference() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.ignoreSwaggerDifference", false);
        return property.get();
    }

    public boolean isPreferIpAddress() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.preferIpAddress", false);
        return property.get();
    }

    public boolean isWatch() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.watch", true);
        return property.get();
    }

    public boolean isClientAuthEnabled() {
        String isAuthEnabled = this.getProperty("false", "servicecomb.auth.enabled");
        return Boolean.parseBoolean(isAuthEnabled);
    }

    public String getRegistryApiVersion() {
        return this.getProperty("v4", "servicecomb.service.registry.api.version");
    }

    public String getTenantName() {
        return this.getProperty("default", "servicecomb.config.client.tenantName");
    }

    public String getDomainName() {
        return this.getProperty("default", "servicecomb.config.client.domainName");
    }

    public String getAccessKey() {
        return this.getProperty(null, "servicecomb.auth.accessKey");
    }

    public String getSecretKey() {
        return this.getProperty(null, "servicecomb.auth.secretKey");
    }

    public Boolean isProxyEnable() {
        String enable = this.getProperty("false", "servicecomb.proxy.enable");
        return Boolean.parseBoolean(enable);
    }

    public String getProxyHost() {
        return this.getProperty("127.0.0.1", "servicecomb.proxy.host");
    }

    public int getProxyPort() {
        String port = this.getProperty("8080", "servicecomb.proxy.port");
        return Integer.parseInt(port);
    }

    public String getProxyUsername() {
        return this.getProperty(null, "servicecomb.proxy.username");
    }

    public String getProxyPasswd() {
        return this.getProperty(null, "servicecomb.proxy.passwd");
    }

    public List<AuthHeaderProvider> getAuthHeaderProviders() {
        return SPIServiceUtils.getAllService(AuthHeaderProvider.class);
    }

    private String getProperty(String defaultValue, String ... keys) {
        String property = null;
        for (String key : keys) {
            property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property != null) break;
        }
        if (property != null) {
            return property;
        }
        return defaultValue;
    }
}

