/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigUtil;

public class BootStrapProperties {
    public static final String OLD_CONFIG_SERVICE_APPLICATION = "APPLICATION_ID";
    public static final String OLD_CONFIG_SERVICE_NAME = "service_description.name";
    public static final String OLD_CONFIG_SERVICE_VERSION = "service_description.version";
    public static final String OLD_CONFIG_SERVICE_ROLE = "service_description.role";
    public static final String OLD_CONFIG_SERVICE_DESCRIPTION = "service_description.description";
    public static final String OLD_CONFIG_SERVICE_ENVIRONMENT = "service_description.environment";
    public static final String OLD_CONFIG_SERVICE_EXTENDED_CLASS = "service_description.propertyExtendedClass";
    public static final String OLD_CONFIG_SERVICE_PROPERTIES = "service_description.properties";
    public static final String OLD_CONFIG_SERVICE_PATHS = "service_description.paths";
    public static final String OLD_CONFIG_SERVICE_INSTANCE_PROPERTIES = "instance_description.properties";
    public static final String OLD_CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS = "instance_description.propertyExtendedClass";
    public static final String OLD_CONFIG_SERVICE_INSTANCE_ENVIRONMENT = "instance_description.environment";
    public static final String OLD_CONFIG_SERVICE_INSTANCE_INITIAL_STATUS = "instance_description.initialStatus";
    private static final String OLD_CONFIG_SERVICE_INSTANCE_TAGS = "instance_description.properties.tags";
    public static final String CONFIG_SERVICE_APPLICATION = "servicecomb.service.application";
    public static final String CONFIG_SERVICE_NAME = "servicecomb.service.name";
    public static final String CONFIG_SERVICE_VERSION = "servicecomb.service.version";
    public static final String CONFIG_SERVICE_ROLE = "servicecomb.service.role";
    public static final String CONFIG_SERVICE_DESCRIPTION = "servicecomb.service.description";
    public static final String CONFIG_SERVICE_ENVIRONMENT = "servicecomb.service.environment";
    public static final String CONFIG_SERVICE_EXTENDED_CLASS = "servicecomb.service.propertyExtendedClass";
    public static final String CONFIG_SERVICE_PROPERTIES = "servicecomb.service.properties";
    public static final String CONFIG_SERVICE_PATHS = "servicecomb.service.paths";
    public static final String CONFIG_SERVICE_INSTANCE_PROPERTIES = "servicecomb.instance.properties";
    public static final String CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS = "servicecomb.instance.propertyExtendedClass";
    public static final String CONFIG_SERVICE_INSTANCE_ENVIRONMENT = "servicecomb.instance.environment";
    public static final String CONFIG_SERVICE_INSTANCE_INITIAL_STATUS = "servicecomb.instance.initialStatus";
    private static final String CONFIG_SERVICE_INSTANCE_TAGS = "servicecomb.instance.properties.tags";
    public static final String DEFAULT_APPLICATION = "default";
    public static final String DEFAULT_MICROSERVICE_NAME = "defaultMicroservice";
    public static final String DEFAULT_MICROSERVICE_VERSION = "1.0.0.0";
    public static final String DEFAULT_MICROSERVICE_ROLE = "FRONT";
    public static final String DEFAULT_MICROSERVICE_ENVIRONMENT = "";
    public static final String DEFAULT_MICROSERVICE_INSTANCE_ENVIRONMENT = "production";
    public static final String DEFAULT_MICROSERVICE_INSTANCE_INITIAL_STATUS = "UP";
    private static final Configuration configuration = ConfigUtil.createLocalConfig();

    public static String readApplication(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_APPLICATION, OLD_CONFIG_SERVICE_APPLICATION, DEFAULT_APPLICATION);
    }

    public static String readApplication() {
        return BootStrapProperties.readApplication(configuration);
    }

    public static String readServiceName(Configuration configuration) {
        String result = BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_NAME, OLD_CONFIG_SERVICE_NAME, DEFAULT_MICROSERVICE_NAME);
        BootStrapProperties.checkMicroserviceName(result);
        return result;
    }

    public static String readServiceName() {
        return BootStrapProperties.readServiceName(configuration);
    }

    public static String readServiceVersion(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_VERSION, OLD_CONFIG_SERVICE_VERSION, DEFAULT_MICROSERVICE_VERSION);
    }

    public static String readServiceVersion() {
        return BootStrapProperties.readServiceVersion(configuration);
    }

    public static String readServiceRole(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_ROLE, OLD_CONFIG_SERVICE_ROLE, DEFAULT_MICROSERVICE_ROLE);
    }

    public static String readServiceRole() {
        return BootStrapProperties.readServiceRole(configuration);
    }

    public static String readServiceDescription(Configuration configuration) {
        String[] descriptionArray = configuration.getStringArray(CONFIG_SERVICE_DESCRIPTION);
        if (null == descriptionArray || descriptionArray.length < 1) {
            descriptionArray = configuration.getStringArray(OLD_CONFIG_SERVICE_DESCRIPTION);
        }
        if (null == descriptionArray || descriptionArray.length < 1) {
            return null;
        }
        StringBuilder rawDescriptionBuilder = new StringBuilder();
        for (String desc : descriptionArray) {
            rawDescriptionBuilder.append(desc).append(",");
        }
        return rawDescriptionBuilder.substring(0, rawDescriptionBuilder.length() - 1);
    }

    public static String readServiceDescription() {
        return BootStrapProperties.readServiceDescription(configuration);
    }

    public static String readServiceEnvironment(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_ENVIRONMENT, OLD_CONFIG_SERVICE_ENVIRONMENT, DEFAULT_MICROSERVICE_ENVIRONMENT);
    }

    public static String readServiceEnvironment() {
        return BootStrapProperties.readServiceEnvironment(configuration);
    }

    public static String readServiceExtendedClass(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_EXTENDED_CLASS, OLD_CONFIG_SERVICE_EXTENDED_CLASS, null);
    }

    public static String readServiceExtendedClass() {
        return BootStrapProperties.readServiceExtendedClass(configuration);
    }

    public static Map<String, String> readServiceProperties(Configuration configuration) {
        return BootStrapProperties.readProperties(configuration, CONFIG_SERVICE_PROPERTIES, OLD_CONFIG_SERVICE_PROPERTIES);
    }

    public static Map<String, String> readServiceProperties() {
        return BootStrapProperties.readServiceProperties(configuration);
    }

    public static List<Object> readServicePaths(Configuration configuration) {
        List result = configuration.getList(CONFIG_SERVICE_PATHS);
        if (result == null || result.isEmpty()) {
            result = configuration.getList(OLD_CONFIG_SERVICE_PATHS);
        }
        return result;
    }

    public static List<Object> readServicePaths() {
        return BootStrapProperties.readServicePaths(configuration);
    }

    public static Map<String, String> readServiceInstanceProperties(Configuration configuration) {
        return BootStrapProperties.readProperties(configuration, CONFIG_SERVICE_INSTANCE_PROPERTIES, OLD_CONFIG_SERVICE_INSTANCE_PROPERTIES);
    }

    public static Map<String, String> readServiceInstanceProperties() {
        return BootStrapProperties.readServiceInstanceProperties(configuration);
    }

    public static String readServiceInstanceExtendedClass(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS, OLD_CONFIG_SERVICE_INSTANCE_EXTENDED_CLASS, null);
    }

    public static String readServiceInstanceExtendedClass() {
        return BootStrapProperties.readServiceInstanceExtendedClass(configuration);
    }

    public static String readServiceInstanceEnvironment(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_INSTANCE_ENVIRONMENT, OLD_CONFIG_SERVICE_INSTANCE_ENVIRONMENT, DEFAULT_MICROSERVICE_INSTANCE_ENVIRONMENT);
    }

    public static String readServiceInstanceEnvironment() {
        return BootStrapProperties.readServiceInstanceEnvironment(configuration);
    }

    public static String readServiceInstanceInitialStatus(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_INSTANCE_INITIAL_STATUS, OLD_CONFIG_SERVICE_INSTANCE_INITIAL_STATUS, DEFAULT_MICROSERVICE_INSTANCE_INITIAL_STATUS);
    }

    public static String readServiceInstanceInitialStatus() {
        return BootStrapProperties.readServiceInstanceInitialStatus(configuration);
    }

    public static String readServiceInstanceTags(Configuration configuration) {
        return BootStrapProperties.readStringValue(configuration, CONFIG_SERVICE_INSTANCE_TAGS, OLD_CONFIG_SERVICE_INSTANCE_TAGS, null);
    }

    public static String readServiceInstanceTags() {
        return BootStrapProperties.readServiceInstanceTags(configuration);
    }

    private static String readStringValue(Configuration configuration, String newKey, String oldKey, String defaultValue) {
        String result = configuration.getString(newKey, null);
        if (result == null) {
            return configuration.getString(oldKey, defaultValue);
        }
        return result;
    }

    private static Map<String, String> readProperties(Configuration configuration, String newKey, String oldKey) {
        AbstractConfiguration subset = (AbstractConfiguration)configuration.subset(newKey);
        if (subset.isEmpty()) {
            subset = (AbstractConfiguration)configuration.subset(oldKey);
        }
        return BootStrapProperties.toStringMap(subset);
    }

    private static Map<String, String> toStringMap(AbstractConfiguration configuration) {
        AbstractConfiguration root = BootStrapProperties.findRoot(configuration);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        configuration.getKeys().forEachRemaining(key -> {
            Object value = configuration.getProperty(key);
            value = PropertyConverter.interpolate((Object)value, (AbstractConfiguration)root);
            map.put((String)key, Objects.toString(value, null));
        });
        return map;
    }

    private static AbstractConfiguration findRoot(AbstractConfiguration configuration) {
        if (configuration instanceof SubsetConfiguration) {
            return BootStrapProperties.findRoot((AbstractConfiguration)((SubsetConfiguration)configuration).getParent());
        }
        return configuration;
    }

    private static void checkMicroserviceName(String name) {
        if (StringUtils.isEmpty((CharSequence)name) || name.contains("${")) {
            throw new IllegalArgumentException(String.format("MicroserviceName '%s' is invalid. you must configure '%s' or set the placeholder value.", name, CONFIG_SERVICE_NAME));
        }
    }
}

