/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.rest.RestProducerInvocationFlow;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.edge.core.CompatiblePathVersionMapper;
import org.apache.servicecomb.edge.core.EdgeInvocation;
import org.apache.servicecomb.edge.core.EdgeInvocationCreator;
import org.apache.servicecomb.edge.core.Utils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxServerResponseToHttpServletResponse;

public class DefaultEdgeDispatcher
extends AbstractEdgeDispatcher {
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.default.enabled";
    private static final String KEY_ORDER = "servicecomb.http.dispatcher.edge.default.order";
    private static final String KEY_PREFIX = "servicecomb.http.dispatcher.edge.default.prefix";
    private static final String KEY_WITH_VERSION = "servicecomb.http.dispatcher.edge.default.withVersion";
    private static final String KEY_PREFIX_SEGMENT_COUNT = "servicecomb.http.dispatcher.edge.default.prefixSegmentCount";
    public static final String MICROSERVICE_NAME = "param0";
    public static final String VERSION = "param1";
    private CompatiblePathVersionMapper versionMapper = new CompatiblePathVersionMapper();
    private String prefix;
    private boolean withVersion;
    private int prefixSegmentCount;

    public int getOrder() {
        return DynamicPropertyFactory.getInstance().getIntProperty(KEY_ORDER, 20000).get();
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_ENABLED, false).get();
    }

    public void init(Router router) {
        this.prefix = DynamicPropertyFactory.getInstance().getStringProperty(KEY_PREFIX, "api").get();
        this.withVersion = DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_WITH_VERSION, true).get();
        this.prefixSegmentCount = DynamicPropertyFactory.getInstance().getIntProperty(KEY_PREFIX_SEGMENT_COUNT, 1).get();
        String regex = this.generateRouteRegex(this.prefix, this.withVersion);
        router.routeWithRegex(regex).handler((Handler)this.createBodyHandler());
        router.routeWithRegex(regex).failureHandler(this::onFailure).handler(this::onRequest);
    }

    @VisibleForTesting
    String generateRouteRegex(String prefix, boolean withVersion) {
        String version = withVersion ? "/([^\\\\/]+)" : "";
        return String.format("/%s/([^\\\\/]+)%s/(.*)", prefix, version);
    }

    protected void onRequest(RoutingContext context) {
        String microserviceName = this.extractMicroserviceName(context);
        String versionRule = this.extractVersionRule(context);
        String path = Utils.findActualPath(context.request().path(), this.prefixSegmentCount);
        if (this.isFilterChainEnabled()) {
            this.requestByFilter(context, microserviceName, versionRule, path);
            return;
        }
        this.requestByHandler(context, microserviceName, versionRule, path);
    }

    protected boolean isFilterChainEnabled() {
        return SCBEngine.getInstance().isFilterChainEnabled();
    }

    private @Nullable String extractMicroserviceName(RoutingContext context) {
        return context.pathParam(MICROSERVICE_NAME);
    }

    private String extractVersionRule(RoutingContext context) {
        if (this.withVersion) {
            String pathVersion = context.pathParam(VERSION);
            return this.versionMapper.getOrCreate(pathVersion).getVersionRule();
        }
        return "0.0.0.0+";
    }

    protected void requestByFilter(RoutingContext context, String microserviceName, String versionRule, String path) {
        VertxServerRequestToHttpServletRequest requestEx = new VertxServerRequestToHttpServletRequest(context);
        VertxServerResponseToHttpServletResponse responseEx = new VertxServerResponseToHttpServletResponse(context.response());
        EdgeInvocationCreator creator = new EdgeInvocationCreator(context, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx, microserviceName, versionRule, path);
        new RestProducerInvocationFlow((InvocationCreator)creator, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx).run();
    }

    private void requestByHandler(RoutingContext context, String microserviceName, String versionRule, String path) {
        EdgeInvocation edgeInvocation = this.createEdgeInvocation();
        edgeInvocation.setVersionRule(versionRule);
        edgeInvocation.init(microserviceName, context, path, this.httpServerFilters);
        edgeInvocation.edgeInvoke();
    }
}

