/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class CseUriTemplateHandler
extends DefaultUriTemplateHandler {
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String USERINFO_PATTERN = "([^@\\[/?#]*)";
    private static final String HOST_IPV4_PATTERN = "[^\\[/?#:]*";
    private static final String HOST_IPV6_PATTERN = "\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]";
    private static final String HOST_PATTERN = "(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*(?:\\{[^/]+?\\})?)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)(:(\\d*(?:\\{[^/]+?\\})?))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");

    public CseUriTemplateHandler() {
        this.setStrictEncoding(true);
    }

    protected URI expandInternal(String uriTemplate, Map<String, ?> uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.createUri(uriTemplate, uriComponents);
    }

    protected URI expandInternal(String uriTemplate, Object ... uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.createUri(uriTemplate, uriComponents);
    }

    protected UriComponentsBuilder initUriComponentsBuilder(String uriTemplate) {
        UriComponentsBuilder builder = CseUriTemplateHandler.fromUriString(uriTemplate);
        if (this.shouldParsePath() && !this.isStrictEncoding()) {
            List pathSegments = builder.build().getPathSegments();
            builder.replacePath(null);
            for (String pathSegment : pathSegments) {
                builder.pathSegment(new String[]{pathSegment});
            }
        }
        return builder;
    }

    private static UriComponentsBuilder fromUriString(String uri) {
        Assert.notNull((Object)uri, (String)"URI must not be null");
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            String rest;
            UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
            String scheme = matcher.group(2);
            String userInfo = matcher.group(5);
            String host = matcher.group(6);
            String port = matcher.group(8);
            String path = matcher.group(9);
            String query = matcher.group(11);
            String fragment = matcher.group(13);
            boolean opaque = false;
            if (StringUtils.hasLength((String)scheme) && !(rest = uri.substring(scheme.length())).startsWith(":/")) {
                opaque = true;
            }
            builder.scheme(scheme);
            if (opaque) {
                String ssp = uri.substring(scheme.length()).substring(1);
                if (StringUtils.hasLength((String)fragment)) {
                    ssp = ssp.substring(0, ssp.length() - (fragment.length() + 1));
                }
                builder.schemeSpecificPart(ssp);
            } else {
                builder.userInfo(userInfo);
                builder.host(host);
                if (StringUtils.hasLength((String)port)) {
                    builder.port(port);
                }
                builder.path(path);
                builder.query(query);
            }
            if (StringUtils.hasText((String)fragment)) {
                builder.fragment(fragment);
            }
            return builder;
        }
        throw new IllegalArgumentException("[" + uri + "] is not a valid URI");
    }

    private URI createUri(String uriTemplate, UriComponents uriComponents) {
        String strUri = uriComponents.toUriString();
        Matcher matcher = URI_PATTERN.matcher(uriTemplate);
        matcher.matches();
        String scheme = matcher.group(2);
        String host = matcher.group(6);
        if (this.isCrossApp(uriTemplate, scheme, host)) {
            int idx = "cse".equals(scheme) ? strUri.indexOf(47, "cse://".length()) : strUri.indexOf(47, "servicecomb://".length());
            strUri = strUri.substring(0, idx) + ":" + strUri.substring(idx + 1);
        }
        try {
            return new URI(strUri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not create URI object: " + ex.getMessage(), ex);
        }
    }

    private boolean isCrossApp(String uriTemplate, String scheme, String host) {
        int pos = "cse".equals(scheme) ? "cse://".length() + host.length() : "servicecomb://".length() + host.length();
        return uriTemplate.charAt(pos) == ':';
    }
}

