/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.registry.cache.InstanceCacheManager;
import org.apache.servicecomb.registry.cache.InstanceCacheManagerNew;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.api.Type;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.refresh.AddressManager;
import org.apache.servicecomb.serviceregistry.refresh.ClassificationAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpPortManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpPortManager.class);
    private ServiceRegistryConfig serviceRegistryConfig;
    InstanceCacheManager instanceCacheManager;
    private ArrayList<IpPort> defaultIpPort;
    private boolean autoDiscoveryInited = false;
    private AddressManager addressManger;
    ClassificationAddress classificationAddress;
    private Object lock = new Object();

    public void setAutoDiscoveryInited(boolean autoDiscoveryInited) {
        this.autoDiscoveryInited = autoDiscoveryInited;
    }

    public int getMaxRetryTimes() {
        return this.classificationAddress.getMaxRetryTimes();
    }

    public IpPortManager(ServiceRegistryConfig serviceRegistryConfig) {
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.instanceCacheManager = new InstanceCacheManagerNew(new AppManager());
        this.defaultIpPort = serviceRegistryConfig.getIpPort();
        if (this.defaultIpPort.isEmpty()) {
            throw new IllegalArgumentException("Service center address is required to start the application.");
        }
        List<String> addresses = this.defaultIpPort.stream().map(IpPort::toString).collect(Collectors.toList());
        this.addressManger = new AddressManager(addresses, EventManager.getEventBus());
        this.classificationAddress = new ClassificationAddress(serviceRegistryConfig, this.instanceCacheManager);
        LOGGER.info("Initial service center address is {}", (Object)this.getAvailableAddress());
    }

    public void initAutoDiscovery() {
        if (!this.autoDiscoveryInited && this.serviceRegistryConfig.isRegistryAutoDiscovery()) {
            for (Type type : Type.values()) {
                this.classificationAddress.initEndPoint(type.name());
            }
            this.setAutoDiscoveryInited(true);
        }
    }

    public IpPort getAvailableAddress() {
        return this.addressManger.getAvailableIpPort();
    }

    public void recordState(String address) {
        this.addressManger.recordFailState(address);
    }
}

