/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.event;

import com.google.common.eventbus.AllowConcurrentEvents;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.apache.servicecomb.foundation.common.event.SubscriberOrder;
import org.apache.servicecomb.foundation.common.utils.LambdaMetafactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSubscriber.class);
    private Object instance;
    private Method method;
    private int order;
    private boolean enableExceptionPropagation;
    private Consumer<Object> lambda;
    private Consumer<Object> dispatcher;

    public SimpleSubscriber(Object instance, Method method) {
        this.instance = instance;
        this.method = method;
        this.enableExceptionPropagation = method.getAnnotation(EnableExceptionPropagation.class) != null;
        SubscriberOrder subscriberOrder = method.getAnnotation(SubscriberOrder.class);
        if (subscriberOrder != null) {
            this.order = subscriberOrder.value();
        }
        try {
            this.lambda = (Consumer)LambdaMetafactoryUtils.createLambda(instance, method, Consumer.class);
        }
        catch (Throwable throwable) {
            LOGGER.warn("Failed to create lambda for method: {}, fallback to reflect.", (Object)method, (Object)throwable);
            SimpleSubscriber.checkAccess(method);
            this.lambda = event -> {
                try {
                    method.invoke(instance, event);
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to call event listener {}.", (Object)method.getName());
                    throw new IllegalStateException(e);
                }
            };
        }
        this.dispatcher = this::syncDispatch;
        if (method.getAnnotation(AllowConcurrentEvents.class) != null) {
            this.dispatcher = this::concurrentDispatch;
        }
    }

    private static void checkAccess(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            throw new IllegalStateException(String.format("The event handler must be a public accessible method. NOTICE: this is change from 2.0 and using higher version of JDK. Declaring class is %s, method is %s", method.getDeclaringClass().getName(), method.getName()));
        }
    }

    public Object getInstance() {
        return this.instance;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getOrder() {
        return this.order;
    }

    public void dispatchEvent(Object event) {
        try {
            this.dispatcher.accept(event);
        }
        catch (Throwable e) {
            if (this.enableExceptionPropagation) {
                throw e;
            }
            LOGGER.error("Event process should not throw exception when @EnableExceptionPropagation not set. ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncDispatch(Object event) {
        SimpleSubscriber simpleSubscriber = this;
        synchronized (simpleSubscriber) {
            this.lambda.accept(event);
        }
    }

    private void concurrentDispatch(Object event) {
        this.lambda.accept(event);
    }
}

