/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.Context;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReactiveResponseExecutor;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.SyncResponseExecutor;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvokerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokerUtils.class);
    private static boolean enableEventLoopBlockingCallCheck = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.invocation.enableEventLoopBlockingCallCheck", true).get();

    public static <T> T syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, responseType);
        return (T)InvokerUtils.syncInvoke(invocation);
    }

    public static void reactiveInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, responseType);
        InvokerUtils.reactiveInvoke(invocation, asyncResp);
    }

    public static <T> T syncInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        return InvokerUtils.syncInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments, responseType);
    }

    public static void reactiveInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        InvokerUtils.reactiveInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments, responseType, asyncResp);
    }

    private static Invocation createInvocation(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        MicroserviceReferenceConfig microserviceReferenceConfig = SCBEngine.getInstance().createMicroserviceReferenceConfig(microserviceName, microserviceVersion);
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getLatestMicroserviceMeta();
        SchemaMeta schemaMeta = microserviceMeta.ensureFindSchemaMeta(schemaId);
        OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
        ReferenceConfig referenceConfig = microserviceReferenceConfig.createReferenceConfig(transport, operationMeta);
        InvocationRuntimeType invocationRuntimeType = operationMeta.buildBaseConsumerRuntimeType();
        invocationRuntimeType.setSuccessResponseType(responseType);
        Invocation invocation = InvocationFactory.forConsumer(referenceConfig, operationMeta, invocationRuntimeType, swaggerArguments);
        return invocation;
    }

    @Deprecated
    public static Object syncInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments) {
        return InvokerUtils.syncInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments);
    }

    @Deprecated
    public static Object syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments) {
        return InvokerUtils.syncInvoke(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, null);
    }

    public static Object syncInvoke(Invocation invocation) throws InvocationException {
        Response response = InvokerUtils.innerSyncInvoke(invocation);
        if (response.isSucceed()) {
            return response.getResult();
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    public static boolean isInEventLoop() {
        return Context.isOnEventLoopThread();
    }

    public static Response innerSyncInvoke(Invocation invocation) {
        try {
            if (enableEventLoopBlockingCallCheck && InvokerUtils.isInEventLoop()) {
                throw new IllegalStateException("Can not execute sync logic in event loop. ");
            }
            invocation.onStart(null, System.nanoTime());
            SyncResponseExecutor respExecutor = new SyncResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.onStartHandlersRequest();
            invocation.next(respExecutor::setResponse);
            Response response = respExecutor.waitResponse(invocation);
            invocation.getInvocationStageTrace().finishHandlersResponse();
            invocation.onFinish(response);
            return response;
        }
        catch (Throwable e) {
            String msg = String.format("invoke failed, %s", invocation.getOperationMeta().getMicroserviceQualifiedName());
            LOGGER.error(msg, e);
            Response response = Response.createConsumerFail((Throwable)e);
            invocation.onFinish(response);
            return response;
        }
    }

    public static void reactiveInvoke(Invocation invocation, AsyncResponse asyncResp) {
        try {
            invocation.onStart(null, System.nanoTime());
            invocation.setSync(false);
            ReactiveResponseExecutor respExecutor = new ReactiveResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.onStartHandlersRequest();
            invocation.next(ar -> {
                ContextUtils.setInvocationContext((InvocationContext)invocation.getParentContext());
                try {
                    invocation.getInvocationStageTrace().finishHandlersResponse();
                    invocation.onFinish(ar);
                    asyncResp.handle(ar);
                }
                finally {
                    ContextUtils.removeInvocationContext();
                }
            });
        }
        catch (Throwable e) {
            invocation.getInvocationStageTrace().finishHandlersResponse();
            Response response = Response.createConsumerFail((Throwable)e);
            invocation.onFinish(response);
            LOGGER.error("invoke failed, {}", (Object)invocation.getOperationMeta().getMicroserviceQualifiedName());
            asyncResp.handle(response);
        }
    }

    public static boolean isSyncMethod(@Nonnull Method method) {
        return !InvokerUtils.isAsyncMethod(method);
    }

    public static boolean isAsyncMethod(@Nonnull Method method) {
        return method.getReturnType().equals(CompletableFuture.class);
    }

    public static CompletableFuture<Response> invoke(Invocation invocation) {
        invocation.onStart(null, System.nanoTime());
        invocation.onStartHandlersRequest();
        return ((CompletableFuture)invocation.getMicroserviceMeta().getFilterChain().onFilter(invocation).exceptionally(throwable -> Exceptions.toConsumerResponse(invocation, throwable))).whenComplete((response, throwable) -> InvokerUtils.finishInvocation(invocation, response));
    }

    private static void finishInvocation(Invocation invocation, Response response) {
        InvokerUtils.processMetrics(invocation, response);
        if (response.isFailed()) {
            AsyncUtils.rethrow((Throwable)((Throwable)response.getResult()));
        }
    }

    private static void processMetrics(Invocation invocation, Response response) {
        invocation.getInvocationStageTrace().finishHandlersResponse();
        invocation.onFinish(response);
    }
}

