/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.darklaunch.oper;

import java.util.regex.Pattern;
import org.apache.servicecomb.darklaunch.oper.AbstractCondition;
import org.apache.servicecomb.darklaunch.oper.SupportedType;

public class LikeCondition
extends AbstractCondition {
    private Pattern pattern;

    public LikeCondition(String key, String expected) {
        super(key, expected);
        char[] cs = expected.toCharArray();
        StringBuilder regExp = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '*') {
                regExp.append(Pattern.quote(new String(cs, lastPos, i - lastPos)));
                regExp.append(".*");
                lastPos = i + 1;
                continue;
            }
            if (cs[i] != '?') continue;
            regExp.append(Pattern.quote(new String(cs, lastPos, i - lastPos)));
            regExp.append(".");
            i = 1;
            lastPos = 1;
        }
        regExp.append(Pattern.quote(new String(cs, lastPos, cs.length - lastPos)));
        this.pattern = Pattern.compile(regExp.toString());
    }

    @Override
    public boolean match() {
        SupportedType type = this.getType();
        if (type == SupportedType.STRING) {
            return this.pattern.matcher((String)this.getActual()).matches();
        }
        return false;
    }
}

