/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.darklaunch.oper;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.darklaunch.oper.AndCondition;
import org.apache.servicecomb.darklaunch.oper.CaseInsensitiveCondition;
import org.apache.servicecomb.darklaunch.oper.Condition;
import org.apache.servicecomb.darklaunch.oper.EqualCondition;
import org.apache.servicecomb.darklaunch.oper.GreaterCondition;
import org.apache.servicecomb.darklaunch.oper.GreaterOrEqualCondition;
import org.apache.servicecomb.darklaunch.oper.LessCondition;
import org.apache.servicecomb.darklaunch.oper.LessOrEqualCondition;
import org.apache.servicecomb.darklaunch.oper.LikeCondition;
import org.apache.servicecomb.darklaunch.oper.NotEqualCondition;
import org.apache.servicecomb.darklaunch.oper.OrCondition;

public class ConditionFactory {
    public static final String OP_AND = "&&";
    public static final String OP_OR = "||";
    public static final String OP_OR_ESCAPE = "\\|\\|";
    private static final String[] OP_LIST = new String[]{">=", "<=", "!=", "=", ">", "<", "~"};
    public static final String SEP_COLON = ",";

    private static String[] split2Part(String str, String sep) {
        int index = str.indexOf(sep);
        if (index > 0) {
            return new String[]{str.substring(0, index), str.substring(index + sep.length())};
        }
        return new String[]{str};
    }

    private static String[] split(String str, String sep) {
        return Arrays.stream(str.split(sep)).filter(s -> !StringUtils.isEmpty((CharSequence)s)).collect(Collectors.toList()).toArray(new String[0]);
    }

    public static Condition buildRateCondition(String strCondition) {
        return new LessCondition("rate", strCondition);
    }

    public static Condition buildCondition(String strCondition, boolean caseInsensitive) {
        if (strCondition.contains(OP_AND)) {
            String[] rules = ConditionFactory.split(strCondition, OP_AND);
            Condition[] conditions = new Condition[rules.length];
            for (int i = 0; i < conditions.length; ++i) {
                conditions[i] = ConditionFactory.buildGroupConditionItem(rules[i], caseInsensitive);
            }
            return new AndCondition(conditions);
        }
        if (strCondition.contains(OP_OR)) {
            String[] rules = ConditionFactory.split(strCondition, OP_OR_ESCAPE);
            Condition[] conditions = new Condition[rules.length];
            for (int i = 0; i < conditions.length; ++i) {
                conditions[i] = ConditionFactory.buildGroupConditionItem(rules[i], caseInsensitive);
            }
            return new OrCondition(conditions);
        }
        return ConditionFactory.buildGroupConditionItem(strCondition, caseInsensitive);
    }

    private static Condition buildGroupConditionItem(String groupCondition, boolean caseInsensitive) {
        for (int index = 0; index < OP_LIST.length; ++index) {
            if (!groupCondition.contains(OP_LIST[index])) continue;
            String[] pairs = ConditionFactory.split2Part(groupCondition, OP_LIST[index]);
            if (pairs[1].contains(SEP_COLON)) {
                String[] values = ConditionFactory.split(pairs[1], SEP_COLON);
                Condition[] conditions = new Condition[values.length];
                for (int i = 0; i < values.length; ++i) {
                    conditions[i] = ConditionFactory.buildCondition(index, pairs[0], values[i], caseInsensitive);
                }
                return new OrCondition(conditions);
            }
            return ConditionFactory.buildCondition(index, pairs[0], pairs[1], caseInsensitive);
        }
        throw new IllegalArgumentException(groupCondition);
    }

    private static Condition buildCondition(int index, String key, String value, boolean caseInsensitive) {
        value = caseInsensitive ? value.toLowerCase() : value;
        Condition condition = ConditionFactory.buildCondition(index, key, value);
        if (caseInsensitive) {
            return new CaseInsensitiveCondition(condition);
        }
        return condition;
    }

    private static Condition buildCondition(int index, String key, String value) {
        switch (index) {
            case 0: {
                return new GreaterOrEqualCondition(key, value);
            }
            case 1: {
                return new LessOrEqualCondition(key, value);
            }
            case 2: {
                return new NotEqualCondition(key, value);
            }
            case 3: {
                return new EqualCondition(key, value);
            }
            case 4: {
                return new GreaterCondition(key, value);
            }
            case 5: {
                return new LessCondition(key, value);
            }
        }
        return new LikeCondition(key, value);
    }
}

