/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.center.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.http.client.common.HttpUtils;

public class AddressManager {
    public static final String DEFAULT_PROJECT = "default";
    private final String projectName;
    private final List<String> addresses;
    private int index = 0;

    public AddressManager(String projectName, List<String> addresses) {
        this.projectName = StringUtils.isEmpty((String)projectName) ? DEFAULT_PROJECT : projectName;
        this.addresses = new ArrayList<String>(addresses.size());
        addresses.forEach(address -> this.addresses.add(this.formatAddress((String)address)));
    }

    private String formatAddress(String address) {
        try {
            return address + "/v3/" + HttpUtils.encodeURLParam((String)this.projectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("not possible");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String address() {
        AddressManager addressManager = this;
        synchronized (addressManager) {
            ++this.index;
            if (this.index >= this.addresses.size()) {
                this.index = 0;
            }
            return this.addresses.get(this.index);
        }
    }

    public boolean sslEnabled() {
        return this.address().startsWith("https://");
    }
}

