/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.edge.core.EdgeInvocation;
import org.apache.servicecomb.edge.core.URLMappedConfigurationItem;
import org.apache.servicecomb.edge.core.URLMappedConfigurationLoader;
import org.apache.servicecomb.edge.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLMappedEdgeDispatcher
extends AbstractEdgeDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(URLMappedEdgeDispatcher.class);
    public static final String CONFIGURATION_ITEM = "URLMappedConfigurationItem";
    private static final String PATTERN_ANY = "/(.*)";
    private static final String KEY_ORDER = "servicecomb.http.dispatcher.edge.url.order";
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.url.enabled";
    private static final String KEY_PATTERN = "servicecomb.http.dispatcher.edge.url.pattern";
    private static final String KEY_MAPPING_PREFIX = "servicecomb.http.dispatcher.edge.url.mappings";
    private Map<String, URLMappedConfigurationItem> configurations = new HashMap<String, URLMappedConfigurationItem>();

    public URLMappedEdgeDispatcher() {
        if (this.enabled()) {
            this.loadConfigurations();
        }
    }

    public int getOrder() {
        return DynamicPropertyFactory.getInstance().getIntProperty(KEY_ORDER, 30000).get();
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_ENABLED, false).get();
    }

    public void init(Router router) {
        String pattern = DynamicPropertyFactory.getInstance().getStringProperty(KEY_PATTERN, PATTERN_ANY).get();
        router.routeWithRegex(pattern).failureHandler(this::onFailure).handler(this::preCheck).handler((Handler)this.createBodyHandler()).handler(this::onRequest);
    }

    private void loadConfigurations() {
        ConcurrentCompositeConfiguration config = (ConcurrentCompositeConfiguration)DynamicPropertyFactory.getBackingConfigurationSource();
        this.configurations = URLMappedConfigurationLoader.loadConfigurations(config, KEY_MAPPING_PREFIX);
        config.addConfigurationListener(event -> {
            if (event.getPropertyName().startsWith(KEY_MAPPING_PREFIX)) {
                LOG.info("Map rule have been changed. Reload configurations. Event=" + event.getType());
                this.configurations = URLMappedConfigurationLoader.loadConfigurations(config, KEY_MAPPING_PREFIX);
            }
        });
    }

    protected void preCheck(RoutingContext context) {
        URLMappedConfigurationItem configurationItem = this.findConfigurationItem(context.request().path());
        if (configurationItem == null) {
            context.put("__bypass_body_handler", (Object)Boolean.TRUE);
            context.next();
            return;
        }
        context.put(CONFIGURATION_ITEM, (Object)configurationItem);
        context.next();
    }

    protected void onRequest(RoutingContext context) {
        Boolean bypass = (Boolean)context.get("__bypass_body_handler");
        if (Boolean.TRUE.equals(bypass)) {
            context.put("__bypass_body_handler", (Object)Boolean.FALSE);
            context.next();
            return;
        }
        URLMappedConfigurationItem configurationItem = (URLMappedConfigurationItem)context.get(CONFIGURATION_ITEM);
        String path = Utils.findActualPath(context.request().path(), configurationItem.getPrefixSegmentCount());
        EdgeInvocation edgeInvocation = this.createEdgeInvocation();
        if (configurationItem.getVersionRule() != null) {
            edgeInvocation.setVersionRule(configurationItem.getVersionRule());
        }
        edgeInvocation.init(configurationItem.getMicroserviceName(), context, path, this.httpServerFilters);
        edgeInvocation.edgeInvoke();
    }

    private URLMappedConfigurationItem findConfigurationItem(String path) {
        for (URLMappedConfigurationItem item : this.configurations.values()) {
            if (!item.getPattern().matcher(path).matches()) continue;
            return item;
        }
        return null;
    }
}

