/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie;

import com.google.common.eventbus.Subscribe;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.servicecomb.config.common.ConfigConverter;
import org.apache.servicecomb.config.common.ConfigurationChangedEvent;
import org.apache.servicecomb.config.kie.KieConfig;
import org.apache.servicecomb.config.kie.TransportUtils;
import org.apache.servicecomb.config.kie.client.KieClient;
import org.apache.servicecomb.config.kie.client.KieConfigManager;
import org.apache.servicecomb.config.kie.client.KieConfigOperation;
import org.apache.servicecomb.config.kie.client.model.KieAddressManager;
import org.apache.servicecomb.config.kie.client.model.KieConfiguration;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieConfigurationSourceImpl
implements ConfigCenterConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieConfigurationSourceImpl.class);
    private List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();
    private KieConfigManager kieConfigManager;
    private ConfigConverter configConverter;

    public int getOrder() {
        return 200;
    }

    public boolean isValidSource(Configuration localConfiguration) {
        KieConfig.setFinalConfig((ConcurrentCompositeConfiguration)localConfiguration);
        if (StringUtils.isEmpty((CharSequence)KieConfig.INSTANCE.getServerUri())) {
            LOGGER.info("Kie server is not configured.");
            return false;
        }
        return true;
    }

    public void init(Configuration localConfiguration) {
        this.configConverter = new ConfigConverter(KieConfig.INSTANCE.getFileSources());
        KieAddressManager kieAddressManager = this.configKieAddressManager();
        RequestConfig.Builder requestBuilder = HttpTransportFactory.defaultRequestConfig();
        if (KieConfig.INSTANCE.enableLongPolling() && KieConfig.INSTANCE.getPollingWaitTime() >= 0) {
            requestBuilder.setConnectionRequestTimeout(KieConfig.INSTANCE.getPollingWaitTime() * 2 * 1000);
            requestBuilder.setSocketTimeout(KieConfig.INSTANCE.getPollingWaitTime() * 2 * 1000);
        }
        HttpTransport httpTransport = this.createHttpTransport(kieAddressManager, requestBuilder.build(), localConfiguration);
        KieConfiguration kieConfiguration = this.createKieConfiguration();
        KieClient kieClient = new KieClient(kieAddressManager, httpTransport, kieConfiguration);
        EventManager.register((Object)this);
        this.kieConfigManager = new KieConfigManager((KieConfigOperation)kieClient, EventManager.getEventBus(), kieConfiguration, this.configConverter);
        this.kieConfigManager.firstPull();
        this.kieConfigManager.startConfigKieManager();
        this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)this.configConverter.getCurrentData(), null, null));
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)event.getAdded(), (Map)event.getUpdated(), (Map)event.getDeleted()));
    }

    private KieConfiguration createKieConfiguration() {
        return new KieConfiguration().setAppName(KieConfig.INSTANCE.getAppName()).setFirstPullRequired(KieConfig.INSTANCE.firstPullRequired()).setCustomLabel(KieConfig.INSTANCE.getCustomLabel()).setCustomLabelValue(KieConfig.INSTANCE.getCustomLabelValue()).setEnableAppConfig(KieConfig.INSTANCE.enableAppConfig()).setEnableCustomConfig(KieConfig.INSTANCE.enableCustomConfig()).setEnableLongPolling(KieConfig.INSTANCE.enableLongPolling()).setEnableServiceConfig(KieConfig.INSTANCE.enableServiceConfig()).setEnvironment(KieConfig.INSTANCE.getEnvironment()).setPollingWaitInSeconds(KieConfig.INSTANCE.getPollingWaitTime()).setProject(KieConfig.INSTANCE.getDomainName()).setServiceName(KieConfig.INSTANCE.getServiceName());
    }

    private HttpTransport createHttpTransport(KieAddressManager kieAddressManager, RequestConfig requestConfig, Configuration localConfiguration) {
        List authHeaderProviders = SPIServiceUtils.getOrLoadSortedService(AuthHeaderProvider.class);
        if (KieConfig.INSTANCE.isProxyEnable().booleanValue()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
            HttpHost proxy = new HttpHost(KieConfig.INSTANCE.getProxyHost(), KieConfig.INSTANCE.getProxyPort(), "http");
            httpClientBuilder.setProxy(proxy);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(KieConfig.INSTANCE.getProxyUsername(), KieConfig.INSTANCE.getProxyPasswd()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(kieAddressManager.sslEnabled(), localConfiguration, "kie.consumer"), (RequestAuthHeaderProvider)KieConfigurationSourceImpl.getRequestAuthHeaderProvider(authHeaderProviders), (HttpClientBuilder)httpClientBuilder);
        }
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(kieAddressManager.sslEnabled(), localConfiguration, "kie.consumer"), (RequestAuthHeaderProvider)KieConfigurationSourceImpl.getRequestAuthHeaderProvider(authHeaderProviders), (RequestConfig)requestConfig);
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }

    private KieAddressManager configKieAddressManager() {
        KieAddressManager kieAddressManager = new KieAddressManager(Arrays.asList(KieConfig.INSTANCE.getServerUri().split(",")));
        return kieAddressManager;
    }

    private void updateConfiguration(WatchedUpdateResult result) {
        LOGGER.info("configuration changed keys, added=[{}], updated=[{}], deleted=[{}]", new Object[]{result.getAdded() == null ? "" : result.getAdded().keySet(), result.getChanged() == null ? "" : result.getChanged().keySet(), result.getDeleted() == null ? "" : result.getDeleted().keySet()});
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                LOGGER.error("Error in invoking WatchedUpdateListener", ex);
            }
        }
    }

    public void destroy() {
        if (this.kieConfigManager == null) {
            return;
        }
        this.kieConfigManager.stop();
    }

    public void addUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.add(watchedUpdateListener);
    }

    public void removeUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.remove(watchedUpdateListener);
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return Collections.emptyMap();
    }
}

