/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.registry.consumer.MicroserviceManager;
import org.apache.servicecomb.registry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppManager.class);
    private Map<String, MicroserviceManager> apps = new ConcurrentHashMapEx();

    public AppManager() {
        this.getEventBus().register((Object)this);
    }

    public EventBus getEventBus() {
        return EventManager.getEventBus();
    }

    public Map<String, MicroserviceManager> getApps() {
        return this.apps;
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String appId, String microserviceName, String versionRule) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersionRule(microserviceName, versionRule);
    }

    public MicroserviceManager getOrCreateMicroserviceManager(String appId) {
        return this.apps.computeIfAbsent(appId, id -> new MicroserviceManager(this, appId));
    }

    public CompletableFuture<MicroserviceVersions> getOrCreateMicroserviceVersionsAsync(String appId, String microserviceName) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersionsAsync(microserviceName);
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String appId, String microserviceName) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersions(microserviceName);
    }

    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        MicroserviceManager microserviceManager = this.apps.get(changedEvent.getKey().getAppId());
        if (microserviceManager == null) {
            return;
        }
        microserviceManager.onMicroserviceInstanceChanged(changedEvent);
    }

    public void pullInstances() {
        for (MicroserviceManager microserviceManager : this.apps.values()) {
            microserviceManager.pullInstances();
        }
    }

    public void safePullInstances() {
        try {
            this.pullInstances();
        }
        catch (Exception e) {
            LOGGER.error("failed to pull instances.", (Throwable)e);
        }
    }

    public void markWaitingDelete(String appId, String microserviceName) {
        Optional.ofNullable(this.apps.get(appId)).map(microserviceManager -> microserviceManager.getVersionsByName().get(microserviceName)).ifPresent(MicroserviceVersions::markWaitingDelete);
    }
}

