/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.response.HeartbeatResponse;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.event.HeartbeatFailEvent;
import org.apache.servicecomb.serviceregistry.event.HeartbeatSuccEvent;
import org.apache.servicecomb.serviceregistry.task.AbstractTask;
import org.apache.servicecomb.serviceregistry.task.HeartbeatResult;
import org.apache.servicecomb.serviceregistry.task.MicroserviceWatchTask;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceInstanceHeartbeatTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceInstanceHeartbeatTask.class);
    private MicroserviceInstance microserviceInstance;
    private HeartbeatResult heartbeatResult;

    public MicroserviceInstanceHeartbeatTask(EventBus eventBus, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.microserviceInstance = microservice.getInstance();
    }

    @Subscribe
    public void onMicroserviceWatchTask(MicroserviceWatchTask task) {
        if (task.taskStatus == TaskStatus.READY && this.isSameMicroservice(task.getMicroservice())) {
            this.taskStatus = TaskStatus.READY;
        }
    }

    public HeartbeatResult getHeartbeatResult() {
        return this.heartbeatResult;
    }

    public boolean isNeedRegisterInstance() {
        return HeartbeatResult.INSTANCE_NOT_REGISTERED.equals((Object)this.heartbeatResult);
    }

    @Override
    public void doRun() {
        this.heartbeatResult = this.heartbeat();
    }

    private HeartbeatResult heartbeat() {
        HeartbeatResponse response = this.srClient.heartbeat(this.microserviceInstance.getServiceId(), this.microserviceInstance.getInstanceId());
        if (response == null) {
            LOGGER.error("Disconnected from service center and heartbeat failed for microservice instance={}/{}", (Object)this.microserviceInstance.getServiceId(), (Object)this.microserviceInstance.getInstanceId());
            this.eventBus.post((Object)new HeartbeatFailEvent());
            return HeartbeatResult.DISCONNECTED;
        }
        if (!response.isOk()) {
            LOGGER.error("Update heartbeat to service center failed, microservice instance={}/{} does not exist", (Object)this.microserviceInstance.getServiceId(), (Object)this.microserviceInstance.getInstanceId());
            this.eventBus.post((Object)new HeartbeatFailEvent());
            return HeartbeatResult.INSTANCE_NOT_REGISTERED;
        }
        this.eventBus.post((Object)new HeartbeatSuccEvent());
        return HeartbeatResult.SUCCESS;
    }
}

