/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.servicecomb.common.rest.UploadConfig;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;
import org.apache.servicecomb.transport.rest.servlet.RestServlet;
import org.apache.servicecomb.transport.rest.servlet.RestServletInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServletUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletUtils.class);

    public static boolean canPublishEndpoint(String listenAddress) {
        if (StringUtils.isEmpty((Object)listenAddress)) {
            LOGGER.info("listenAddress is null, can not publish.");
            return false;
        }
        IpPort ipPort = NetUtils.parseIpPortFromURI((String)("http://" + listenAddress));
        if (ipPort == null) {
            LOGGER.info("invalid listenAddress {}, can not publish, format should be ip:port.", (Object)listenAddress);
            return false;
        }
        if (NetUtils.canTcpListen((InetAddress)ipPort.getSocketAddress().getAddress(), (int)ipPort.getPort())) {
            LOGGER.info("{} is not listened, can not publish.", (Object)ipPort.getSocketAddress());
            return false;
        }
        return true;
    }

    static void checkUrlPattern(String urlPattern) {
        if (!urlPattern.startsWith("/")) {
            throw new ServiceCombException("only support rule like /* or /path/* or /path1/path2/* and so on.");
        }
        int idx = urlPattern.indexOf("/*");
        if (idx < 0 || idx >= 0 && idx != urlPattern.length() - 2) {
            throw new ServiceCombException("only support rule like /* or /path/* or /path1/path2/* and so on.");
        }
    }

    static String[] filterUrlPatterns(String ... urlPatterns) {
        return ServletUtils.filterUrlPatterns(Arrays.asList(urlPatterns));
    }

    static String[] filterUrlPatterns(Collection<String> urlPatterns) {
        return (String[])urlPatterns.stream().filter(pattern -> !pattern.trim().isEmpty()).filter(pattern -> {
            ServletUtils.checkUrlPattern(pattern.trim());
            return true;
        }).toArray(String[]::new);
    }

    static String[] collectUrlPatterns(ServletContext servletContext, Class<?> servletCls) {
        List<ServletRegistration> servlets = ServletUtils.findServletRegistrations(servletContext, servletCls);
        if (servlets.isEmpty()) {
            return new String[0];
        }
        ServletRegistration servletRegistration = servlets.get(0);
        Collection mappings = servletRegistration.getMappings();
        if (servlets.size() > 1) {
            LOGGER.info("Found {} {} registered, select the first one, mappings={}.", new Object[]{servlets.size(), servletCls.getName(), mappings});
        }
        return ServletUtils.filterUrlPatterns(mappings);
    }

    static List<ServletRegistration> findServletRegistrations(ServletContext servletContext, Class<?> servletCls) {
        return servletContext.getServletRegistrations().values().stream().filter(predicate -> predicate.getClassName().equals(servletCls.getName())).collect(Collectors.toList());
    }

    static String collectUrlPrefix(ServletContext servletContext, Class<?> servletCls) {
        String[] urlPatterns = ServletUtils.collectUrlPatterns(servletContext, servletCls);
        if (urlPatterns.length == 0) {
            return null;
        }
        String urlPattern = urlPatterns[0];
        return servletContext.getContextPath() + urlPattern.substring(0, urlPattern.length() - 2);
    }

    public static void saveUrlPrefix(ServletContext servletContext) {
        String urlPrefix = ServletUtils.collectUrlPrefix(servletContext, RestServlet.class);
        if (urlPrefix == null) {
            LOGGER.info("RestServlet not found, will not save UrlPrefix.");
            return;
        }
        ClassLoaderScopeContext.setClassLoaderScopeProperty((String)"urlPrefix", (String)urlPrefix);
        LOGGER.info("UrlPrefix of this instance is \"{}\".", (Object)urlPrefix);
    }

    static File createUploadDir(ServletContext servletContext, String location) {
        File dir = new File(location);
        if (!dir.isAbsolute()) {
            dir = new File((File)servletContext.getAttribute("javax.servlet.context.tempdir"), location).getAbsoluteFile();
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    static void setServletParameters(ServletContext servletContext) {
        UploadConfig uploadConfig = new UploadConfig();
        MultipartConfigElement multipartConfig = uploadConfig.toMultipartConfigElement();
        if (multipartConfig == null) {
            return;
        }
        File dir = ServletUtils.createUploadDir(servletContext, multipartConfig.getLocation());
        LOGGER.info("set uploads directory to \"{}\".", (Object)dir.getAbsolutePath());
        List<ServletRegistration> servlets = ServletUtils.findServletRegistrations(servletContext, RestServlet.class);
        for (ServletRegistration servletRegistration : servlets) {
            if (!ServletRegistration.Dynamic.class.isInstance(servletRegistration)) continue;
            ServletRegistration.Dynamic dynamic = (ServletRegistration.Dynamic)servletRegistration;
            dynamic.setMultipartConfig(multipartConfig);
        }
    }

    public static void init(ServletContext servletContext) {
        RestServletInjector.defaultInject(servletContext);
        ServletUtils.saveUrlPrefix(servletContext);
        ServletUtils.setServletParameters(servletContext);
    }
}

