/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.inspector.internal;

import org.apache.servicecomb.config.priority.PriorityPropertyFactory;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.inspector.internal.InspectorConfig;
import org.apache.servicecomb.inspector.internal.InspectorImpl;
import org.apache.servicecomb.registry.RegistrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InspectorBootListener
implements BootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectorBootListener.class);
    private final InspectorConfig inspectorConfig;
    private final PriorityPropertyFactory propertyFactory;

    public InspectorBootListener(InspectorConfig inspectorConfig, PriorityPropertyFactory propertyFactory) {
        this.inspectorConfig = inspectorConfig;
        this.propertyFactory = propertyFactory;
    }

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    public void onAfterTransport(BootListener.BootEvent event) {
        if (!this.inspectorConfig.isEnabled()) {
            LOGGER.info("inspector is not enabled.");
            return;
        }
        LOGGER.info("inspector is enabled.");
        InspectorImpl inspector = new InspectorImpl().setInspectorConfig(this.inspectorConfig).setPropertyFactory(this.propertyFactory).setSchemas(RegistrationManager.INSTANCE.getMicroservice().getSchemaMap()).correctBasePathForOnlineTest(event.getScbEngine());
        event.getScbEngine().getProducerProviderManager().registerSchema("inspector", (Object)inspector);
    }
}

