/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.ext.web.RoutingContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.springframework.util.StringUtils;

public class ConfigurableDatetimeAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String DEFAULT_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DEFAULT_LOCALE = Locale.US;
    private final ThreadLocal<SimpleDateFormat> datetimeFormatHolder = new ThreadLocal();
    private String pattern;
    private TimeZone timezone;
    private Locale locale;

    public ConfigurableDatetimeAccessItem() {
        this(DEFAULT_DATETIME_PATTERN);
    }

    public ConfigurableDatetimeAccessItem(String config) {
        String[] configArr = null;
        if (config.contains("|")) {
            configArr = this.splitConfig(config);
        } else {
            configArr = new String[3];
            configArr[0] = config;
        }
        if (3 != configArr.length) {
            throw new IllegalArgumentException("wrong format of configuration, \"PATTERN|TIMEZONE|LOCALE\" is expected, but actually is \"" + config + "\"");
        }
        this.setConfigruations(configArr);
    }

    private String[] splitConfig(String config) {
        return config.split("\\|{1}?", -1);
    }

    private void setConfigruations(String[] configArr) {
        this.pattern = StringUtils.isEmpty((Object)configArr[0]) ? DEFAULT_DATETIME_PATTERN : configArr[0];
        this.timezone = StringUtils.isEmpty((Object)configArr[1]) ? TimeZone.getDefault() : TimeZone.getTimeZone(configArr[1]);
        this.locale = StringUtils.isEmpty((Object)configArr[2]) ? DEFAULT_LOCALE : Locale.forLanguageTag(configArr[2]);
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        this.doAppendFormattedItem(accessLogEvent.getMilliStartTime(), builder);
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        long milliDuration = (finishEvent.getInvocation().getInvocationStageTrace().getStartSend() - finishEvent.getInvocation().getInvocationStageTrace().getStart()) / 1000000L;
        this.doAppendFormattedItem(finishEvent.getInvocation().getInvocationStageTrace().getStartTimeMillis() + milliDuration, builder);
    }

    private void doAppendFormattedItem(long milliStartTime, StringBuilder builder) {
        SimpleDateFormat dateFormat = this.getDatetimeFormat();
        builder.append(dateFormat.format(new Date(milliStartTime)));
    }

    private SimpleDateFormat getDatetimeFormat() {
        SimpleDateFormat dateFormat = this.datetimeFormatHolder.get();
        if (null == dateFormat) {
            dateFormat = new SimpleDateFormat(this.pattern, this.locale);
            dateFormat.setTimeZone(this.timezone);
            this.datetimeFormatHolder.set(dateFormat);
        }
        return dateFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

