/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.loadbalance.ServerListFilterExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.router.RouterFilter;
import org.apache.servicecomb.router.custom.RouterHeaderFilterExt;
import org.apache.servicecomb.router.custom.ServiceCombCanaryDistributer;
import org.apache.servicecomb.router.distribute.RouterDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterServerListFilter
implements ServerListFilterExt {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterServerListFilter.class);
    private static final String ENABLE = "servicecomb.router.type";
    private static final String TYPE_ROUTER = "router";
    private static final String ROUTER_HEADER = "X-RouterContext";
    RouterDistributor<ServiceCombServer, Microservice> distributer = new ServiceCombCanaryDistributer();

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getStringProperty(ENABLE, "").get().equals(TYPE_ROUTER);
    }

    public List<ServiceCombServer> getFilteredListOfServers(List<ServiceCombServer> list, Invocation invocation) {
        String targetServiceName = invocation.getMicroserviceName();
        Map<String, String> headers = this.addHeaders(invocation);
        headers = this.filterHeaders(headers);
        return RouterFilter.getFilteredListOfServers(list, targetServiceName, headers, this.distributer);
    }

    private Map<String, String> filterHeaders(Map<String, String> headers) {
        List filters = SPIServiceUtils.getOrLoadSortedService(RouterHeaderFilterExt.class);
        for (RouterHeaderFilterExt filterExt : filters) {
            if (!filterExt.enabled()) continue;
            headers = filterExt.doFilter(headers);
        }
        return headers;
    }

    private Map<String, String> addHeaders(Invocation invocation) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (invocation.getContext(ROUTER_HEADER) != null) {
            Map canaryContext = null;
            try {
                canaryContext = (Map)JsonUtils.OBJ_MAPPER.readValue(invocation.getContext(ROUTER_HEADER), (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (JsonProcessingException e) {
                LOGGER.error("canary context serialization failed");
            }
            if (canaryContext != null) {
                headers.putAll(canaryContext);
            }
        }
        invocation.getInvocationArguments().forEach((k, v) -> headers.put((String)k, v == null ? null : v.toString()));
        headers.putAll(invocation.getContext());
        return headers;
    }
}

