/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;

public class EndpointMeter {
    private static final double SNV_MILLI_SECONDS = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    public static final String ADDRESS = "address";
    public static final String STATISTIC = "statistic";
    public static final String CONNECT_COUNT = "connectCount";
    public static final String DISCONNECT_COUNT = "disconnectCount";
    public static final String CONNECTIONS = "connections";
    public static final String BYTES_READ = "bytesRead";
    public static final String BYTES_WRITTEN = "bytesWritten";
    public static final String REQUESTS = "requests";
    public static final String LATENCY = "latency";
    protected Id id;
    private Id idConnect;
    private Id idDisconnect;
    private Id idConnections;
    private Id idBytesRead;
    private Id idBytesWritten;
    private Id idRequests;
    private Id idLatency;
    protected DefaultEndpointMetric metric;
    private long lastConnectCount;
    private long lastDisconnectCount;
    private long lastBytesRead;
    private long lastBytesWritten;
    private long lastRequests;
    private long lastLatency;

    public EndpointMeter(Id id, DefaultEndpointMetric metric) {
        this.id = id = id.withTag(ADDRESS, metric.getAddress());
        this.idConnect = id.withTag(STATISTIC, CONNECT_COUNT);
        this.idDisconnect = id.withTag(STATISTIC, DISCONNECT_COUNT);
        this.idConnections = id.withTag(STATISTIC, CONNECTIONS);
        this.idBytesRead = id.withTag(STATISTIC, BYTES_READ);
        this.idBytesWritten = id.withTag(STATISTIC, BYTES_WRITTEN);
        this.idRequests = id.withTag(STATISTIC, REQUESTS);
        this.idLatency = id.withTag(STATISTIC, LATENCY);
        this.metric = metric;
    }

    public DefaultEndpointMetric getMetric() {
        return this.metric;
    }

    protected Measurement newMeasurement(Id id, long timestamp, Number n) {
        return new Measurement(id, timestamp, n.doubleValue());
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow, double secondInterval) {
        long connectCount = this.metric.getConnectCount();
        long disconnectCount = this.metric.getDisconnectCount();
        long bytesRead = this.metric.getBytesRead();
        long bytesWritten = this.metric.getBytesWritten();
        long requests = this.metric.getRequests();
        long latency = this.metric.getLatency();
        measurements.add(this.newMeasurement(this.idConnect, msNow, connectCount - this.lastConnectCount));
        measurements.add(this.newMeasurement(this.idDisconnect, msNow, disconnectCount - this.lastDisconnectCount));
        measurements.add(this.newMeasurement(this.idConnections, msNow, connectCount - disconnectCount));
        measurements.add(this.newMeasurement(this.idBytesRead, msNow, (double)(bytesRead - this.lastBytesRead) / secondInterval));
        measurements.add(this.newMeasurement(this.idBytesWritten, msNow, (double)(bytesWritten - this.lastBytesWritten) / secondInterval));
        measurements.add(this.newMeasurement(this.idRequests, msNow, (double)(requests - this.lastRequests) / secondInterval));
        measurements.add(this.newMeasurement(this.idLatency, msNow, requests - this.lastRequests == 0L ? 0.0 : (double)((latency - this.lastLatency) / (requests - this.lastRequests)) * SNV_MILLI_SECONDS));
        this.lastConnectCount = connectCount;
        this.lastDisconnectCount = disconnectCount;
        this.lastBytesRead = bytesRead;
        this.lastBytesWritten = bytesWritten;
        this.lastRequests = requests;
        this.lastLatency = latency;
    }
}

