/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.common;

import java.util.HashMap;
import java.util.Map;

public class ConfigurationChangedEvent {
    private final Map<String, Object> added;
    private final Map<String, Object> deleted;
    private final Map<String, Object> updated;

    private ConfigurationChangedEvent(Map<String, Object> added, Map<String, Object> updated, Map<String, Object> deleted) {
        this.added = added;
        this.deleted = deleted;
        this.updated = updated;
    }

    public static ConfigurationChangedEvent createIncremental(Map<String, Object> latest, Map<String, Object> last) {
        HashMap<String, Object> itemsCreated = new HashMap<String, Object>();
        HashMap<String, Object> itemsDeleted = new HashMap<String, Object>();
        HashMap<String, Object> itemsModified = new HashMap<String, Object>();
        for (String itemKey : latest.keySet()) {
            if (!last.containsKey(itemKey)) {
                itemsCreated.put(itemKey, latest.get(itemKey));
                continue;
            }
            if (last.get(itemKey).equals(latest.get(itemKey))) continue;
            itemsModified.put(itemKey, latest.get(itemKey));
        }
        for (String itemKey : last.keySet()) {
            if (latest.containsKey(itemKey)) continue;
            itemsDeleted.put(itemKey, "");
        }
        return ConfigurationChangedEvent.createIncremental(itemsCreated, itemsModified, itemsDeleted);
    }

    public static ConfigurationChangedEvent createIncremental(Map<String, Object> added, Map<String, Object> updated, Map<String, Object> deleted) {
        return new ConfigurationChangedEvent(added, updated, deleted);
    }

    public final Map<String, Object> getAdded() {
        return this.added;
    }

    public final Map<String, Object> getUpdated() {
        return this.updated;
    }

    public final Map<String, Object> getDeleted() {
        return this.deleted;
    }

    public final Map<String, Object> getComplete() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.added.size() + this.updated.size());
        result.putAll(this.added);
        result.putAll(this.updated);
        return result;
    }
}

