/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.inspector.internal;

import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.inspector.internal.InspectorConfig;
import org.apache.servicecomb.inspector.internal.InspectorImpl;
import org.apache.servicecomb.registry.RegistrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectorBootListener
implements BootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectorBootListener.class);

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    public void onAfterTransport(BootListener.BootEvent event) {
        InspectorConfig inspectorConfig = (InspectorConfig)event.getScbEngine().getPriorityPropertyManager().createConfigObject(InspectorConfig.class, new Object[0]);
        if (!inspectorConfig.isEnabled()) {
            LOGGER.info("inspector is not enabled.");
            return;
        }
        LOGGER.info("inspector is enabled.");
        InspectorImpl inspector = new InspectorImpl(event.getScbEngine(), inspectorConfig, RegistrationManager.INSTANCE.getMicroservice().getSchemaMap());
        inspector.setPriorityPropertyManager(event.getScbEngine().getPriorityPropertyManager());
        event.getScbEngine().getProducerProviderManager().registerSchema("inspector", (Object)inspector);
    }
}

