/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.marker;

import java.util.Map;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.marker.Matcher;
import org.apache.servicecomb.governance.marker.operator.MatchOperator;
import org.apache.servicecomb.governance.marker.operator.RawOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestProcessor {
    private static final String OPERATOR_SUFFIX = "Operator";
    @Autowired
    private Map<String, MatchOperator> operatorMap;

    public boolean match(GovernanceRequest request, Matcher matcher) {
        if (matcher.getMethod() != null && !matcher.getMethod().contains(request.getMethod()) || matcher.getApiPath() != null && !this.operatorMatch(request.getUri(), matcher.getApiPath())) {
            return false;
        }
        if (matcher.getHeaders() == null) {
            return true;
        }
        for (Map.Entry<String, RawOperator> entry : matcher.getHeaders().entrySet()) {
            if (request.getHeaders().containsKey(entry.getKey()) && this.operatorMatch(request.getHeaders().get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean operatorMatch(String str, RawOperator rawOperator) {
        if (rawOperator.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : rawOperator.entrySet()) {
            if (this.operatorMap.get((String)entry.getKey() + OPERATOR_SUFFIX).match(str, (String)entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

