/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.vertx.core.VertxException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.governance.handler.ext.RetryExtension;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.stereotype.Component;

@Component
public class ServiceCombRetryExtension
implements RetryExtension {
    public boolean isRetry(List<Integer> statusList, Object result) {
        if (result instanceof Response) {
            Response resp = (Response)result;
            if (resp.isFailed()) {
                if (InvocationException.class.isInstance(resp.getResult())) {
                    InvocationException e = (InvocationException)resp.getResult();
                    return e.getStatusCode() == 490 || e.getStatusCode() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode() || e.getStatusCode() == Response.Status.BAD_GATEWAY.getStatusCode();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Class<? extends Throwable>[] retryExceptions() {
        return new Class[]{ConnectException.class, SocketTimeoutException.class, IOException.class, VertxException.class, NoRouteToHostException.class, InvocationException.class};
    }
}

