/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.server;

import io.vertx.core.json.Json;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.zeroconfig.ZeroConfigRegistryConstants;
import org.apache.servicecomb.zeroconfig.client.ClientUtil;
import org.apache.servicecomb.zeroconfig.server.ServerMicroserviceInstance;
import org.apache.servicecomb.zeroconfig.server.ZeroConfigRegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerUtil.class);
    public static final ServerUtil INSTANCE = new ServerUtil();
    public MulticastSocket multicastSocket;
    private ZeroConfigRegistryService zeroConfigRegistryService;
    private InetAddress group;
    public static Map<String, Map<String, ServerMicroserviceInstance>> microserviceInstanceMap = new ConcurrentHashMapEx();

    private ServerUtil() {
    }

    public synchronized void init() {
        this.zeroConfigRegistryService = new ZeroConfigRegistryService();
        try {
            this.group = InetAddress.getByName("225.0.0.0");
        }
        catch (UnknownHostException e) {
            LOGGER.error("Unknown host exception when creating MulticastSocket group" + e);
        }
        Executors.newSingleThreadExecutor().submit(() -> this.startListenerForRegisterUnregisterEvent());
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::runInstanceHealthCheckerTask, 5L, 3L, TimeUnit.SECONDS);
    }

    private void runInstanceHealthCheckerTask() {
        List<ServerMicroserviceInstance> unhealthyInstanceList;
        if (!microserviceInstanceMap.isEmpty() && !(unhealthyInstanceList = ServerUtil.findUnhealthyInstances()).isEmpty()) {
            ServerUtil.removeDeadInstance(unhealthyInstanceList);
        }
    }

    private static List<ServerMicroserviceInstance> findUnhealthyInstances() {
        ArrayList<ServerMicroserviceInstance> unhealthyInstanceList = new ArrayList<ServerMicroserviceInstance>();
        microserviceInstanceMap.forEach((serviceId, instanceIdMap) -> instanceIdMap.forEach((instanceId, instance) -> {
            if (instance.getLastHeartbeatTimeStamp() != null && instance.getLastHeartbeatTimeStamp().plusSeconds(3L).compareTo(Instant.now()) < 0) {
                unhealthyInstanceList.add((ServerMicroserviceInstance)instance);
                LOGGER.info("Detected a unhealthy service instance. serviceId: {}, instanceId: {}", (Object)instance.getServiceId(), (Object)instance.getInstanceId());
            }
        }));
        return unhealthyInstanceList;
    }

    private static void removeDeadInstance(List<ServerMicroserviceInstance> unhealthyInstanceList) {
        for (ServerMicroserviceInstance deadInstance : unhealthyInstanceList) {
            microserviceInstanceMap.computeIfPresent(deadInstance.getServiceId(), (serviceId, instanceIdMap) -> {
                instanceIdMap.computeIfPresent(deadInstance.getInstanceId(), (instanceId, instance) -> null);
                return !instanceIdMap.isEmpty() ? instanceIdMap : null;
            });
        }
    }

    private void initMulticastSocket() throws IOException {
        this.multicastSocket = new MulticastSocket(ZeroConfigRegistryConstants.PORT);
        this.multicastSocket.joinGroup(this.group);
    }

    private void startListenerForRegisterUnregisterEvent() {
        try {
            try {
                byte[] buffer = new byte[ZeroConfigRegistryConstants.DATA_PACKET_BUFFER_SIZE.intValue()];
                this.initMulticastSocket();
                while (true) {
                    DatagramPacket receivePacketBuffer = new DatagramPacket(buffer, buffer.length);
                    try {
                        this.multicastSocket.receive(receivePacketBuffer);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Caught error when receiving the data packet", (Object)t.getMessage());
                        if (!this.multicastSocket.isClosed()) continue;
                        LOGGER.info("MulticastSocket is closed. Going to restart it.");
                        this.initMulticastSocket();
                        continue;
                    }
                    String receivedEventString = new String(receivePacketBuffer.getData(), 0, receivePacketBuffer.getLength(), "UTF-8").trim();
                    this.handleReceivedEvent(receivedEventString);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create MulticastSocket object. Zero-Config init failed! ", e);
            }
        }
        catch (Throwable throwable) {
            if (this.multicastSocket != null) {
                try {
                    this.multicastSocket.leaveGroup(this.group);
                    this.multicastSocket.close();
                }
                catch (IOException e1) {
                    LOGGER.error("Failed to close the MulticastSocket" + e1);
                }
            }
            throw throwable;
        }
    }

    private void handleReceivedEvent(String receivedString) {
        if (receivedString.length() < 2 || !receivedString.startsWith("{") || !receivedString.endsWith("}")) {
            LOGGER.warn("Wrong format of the received Event string. {}", (Object)receivedString);
            return;
        }
        ServerMicroserviceInstance receivedInstance = (ServerMicroserviceInstance)Json.decodeValue((String)receivedString, ServerMicroserviceInstance.class);
        String event = receivedInstance.getEvent();
        if (StringUtils.isEmpty((CharSequence)event)) {
            LOGGER.warn("There is no Event property defined. {}", (Object)receivedInstance);
            return;
        }
        switch (event) {
            case "register": {
                LOGGER.info("Received REGISTER event: {}", (Object)receivedInstance);
                this.zeroConfigRegistryService.registerMicroserviceInstance(receivedInstance);
                break;
            }
            case "unregister": {
                LOGGER.info("Received UNREGISTER event: {}", (Object)receivedInstance);
                this.zeroConfigRegistryService.unregisterMicroserviceInstance(receivedInstance);
                break;
            }
            case "heartbeat": {
                if (this.isSelfServiceInstance(receivedInstance)) break;
                this.zeroConfigRegistryService.heartbeat(receivedInstance);
                break;
            }
            default: {
                LOGGER.error("Unrecognized event type. event: {}", (Object)event);
            }
        }
    }

    private boolean isSelfServiceInstance(ServerMicroserviceInstance receivedInstance) {
        ServerMicroserviceInstance serviceInstanceForHeartbeat = ClientUtil.INSTANCE.getServiceInstanceForHeartbeat();
        if (serviceInstanceForHeartbeat == null) {
            return false;
        }
        String selfServiceId = serviceInstanceForHeartbeat.getServiceId();
        String selfInstanceId = serviceInstanceForHeartbeat.getInstanceId();
        String serviceId = receivedInstance.getServiceId();
        String instanceId = receivedInstance.getInstanceId();
        return selfServiceId.equals(serviceId) && selfInstanceId.equals(instanceId);
    }
}

