/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import java.util.List;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.zeroconfig.client.ZeroConfigClient;

public class ZeroConfigDiscovery
implements Discovery {
    private static final String NAME = "zero-config discovery";
    private ZeroConfigClient zeroConfigClient = ZeroConfigClient.INSTANCE;
    private String revision;

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.zeroconfig.registry.enabled", true).get();
    }

    public void init() {
    }

    public void run() {
    }

    public void destroy() {
    }

    public int getOrder() {
        return 101;
    }

    public Microservice getMicroservice(String microserviceId) {
        return this.zeroConfigClient.getMicroservice(microserviceId);
    }

    public List<Microservice> getAllMicroservices() {
        return this.zeroConfigClient.getAllMicroservices();
    }

    public String getSchema(String microserviceId, Collection<MicroserviceInstance> instances, String schemaId) {
        return this.zeroConfigClient.getSchema(microserviceId, schemaId);
    }

    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        return this.zeroConfigClient.findMicroserviceInstance(serviceId, instanceId);
    }

    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule) {
        return this.zeroConfigClient.findServiceInstances(appId, serviceName, versionRule);
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String name() {
        return NAME;
    }
}

