/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import com.google.common.eventbus.EventBus;
import org.apache.servicecomb.config.kie.client.KieConfigChangedEvent;
import org.apache.servicecomb.config.kie.client.KieConfigOperation;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsRequest;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsResponse;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieConfigManager
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieConfigManager.class);
    private static long POLL_INTERVAL = 1000L;
    private KieConfigOperation configKieClient;
    private final EventBus eventBus;
    private ConfigurationsRequest configurationsRequest;

    public KieConfigManager(KieConfigOperation configKieClient, EventBus eventBus) {
        super("config-center-configuration-task");
        this.configKieClient = configKieClient;
        this.eventBus = eventBus;
    }

    public void setConfigurationsRequest(ConfigurationsRequest configurationsRequest) {
        this.configurationsRequest = configurationsRequest;
    }

    public void startConfigKieManager() {
        this.startTask(new PollConfigurationTask(0));
    }

    class PollConfigurationTask
    implements Task {
        int failCount = 0;

        public PollConfigurationTask(int failCount) {
            this.failCount = failCount;
        }

        public void execute() {
            try {
                ConfigurationsResponse response = KieConfigManager.this.configKieClient.queryConfigurations(KieConfigManager.this.configurationsRequest);
                if (response.isChanged()) {
                    LOGGER.info("The configurations are change, will refresh local configurations.");
                    KieConfigManager.this.configurationsRequest.setRevision(response.getRevision());
                    KieConfigManager.this.eventBus.post((Object)new KieConfigChangedEvent(response.getConfigurations()));
                }
                KieConfigManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)KieConfigManager.this, POLL_INTERVAL, (Task)new PollConfigurationTask(0)));
            }
            catch (Exception e) {
                LOGGER.error("get configurations from KieConfigCenter failed, and will try again.", (Throwable)e);
                KieConfigManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)KieConfigManager.this, this.failCount + 1, (Task)new PollConfigurationTask(this.failCount + 1)));
            }
        }
    }
}

