/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.invocation.endpoint.EndpointUtils;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.apache.servicecomb.registry.consumer.StaticMicroserviceVersions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public abstract class ThirdServiceRegister
implements BootListener,
EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdServiceRegister.class);
    public static final int ORDER = -1000;
    private static final String VERSION = "1.0";
    protected List<String> urls = Collections.singletonList("http://127.0.0.1");
    protected String appId;
    protected final String microserviceName;
    protected final Map<String, Class<?>> schemaByIdMap = new HashMap();

    public ThirdServiceRegister(String microserviceName) {
        this.microserviceName = microserviceName;
    }

    @Override
    public int getOrder() {
        return -1000;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setEnvironment(Environment environment) {
        String urlKey = this.microserviceName + ".urls";
        List urls = (List)environment.getProperty(urlKey, List.class);
        this.setUrls(urlKey, urls);
    }

    public void setUrls(String urlKey, List<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            LOGGER.warn("missing configuration, key = {}", (Object)urlKey);
            return;
        }
        this.urls = urls;
    }

    protected void addSchema(String schemaId, Class<?> schemaCls) {
        this.schemaByIdMap.put(schemaId, schemaCls);
    }

    @Override
    public void onBeforeRegistry(BootListener.BootEvent event) {
        this.appId = event.getScbEngine().getAppId();
        this.registerMicroserviceMapping();
    }

    protected void registerMicroserviceMapping() {
        List<String> endpoints = this.createEndpoints();
        List<MicroserviceInstance> instances = this.createInstances(endpoints);
        DiscoveryManager.INSTANCE.getAppManager().getOrCreateMicroserviceManager(this.appId).getVersionsByName().computeIfAbsent(this.microserviceName, svcName -> this.createMicroserviceVersions(instances));
        LOGGER.info("register third service, name={}, endpoints={}.", (Object)this.microserviceName, endpoints);
    }

    protected List<String> createEndpoints() {
        return this.urls.stream().map(EndpointUtils::formatFromUri).collect(Collectors.toList());
    }

    protected List<MicroserviceInstance> createInstances(List<String> endpoints) {
        return endpoints.stream().map(endpoint -> {
            MicroserviceInstance instance = new MicroserviceInstance();
            instance.setEndpoints(Collections.singletonList(endpoint));
            return instance;
        }).collect(Collectors.toList());
    }

    protected MicroserviceVersions createMicroserviceVersions(List<MicroserviceInstance> instances) {
        return new StaticMicroserviceVersions(DiscoveryManager.INSTANCE.getAppManager(), this.appId, this.microserviceName).init(this.schemaByIdMap, VERSION, instances);
    }
}

