/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.kie.client.KieConfig;
import org.apache.servicecomb.config.kie.model.KVDoc;
import org.apache.servicecomb.config.kie.model.KVResponse;
import org.apache.servicecomb.config.kie.model.ValueType;
import org.apache.servicecomb.config.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieUtil.class);
    private static final String LABEL_ENV = "environment";
    private static final String LABEL_APP = "app";
    private static final String LABEL_SERVICE = "service";
    private static final String LABEL_VERSION = "version";
    private static final String STATUS_ENABLED = "enabled";

    public static String encrypt(String dataStr) {
        MessageDigest messageDigest = null;
        String result = "";
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(dataStr.getBytes(StandardCharsets.UTF_8));
            result = new BigInteger(1, messageDigest.digest(dataStr.getBytes(StandardCharsets.UTF_8))).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to generate MD5 . ", (Throwable)e);
        }
        return result;
    }

    public static Map<String, Object> getConfigByLabel(KVResponse resp) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<KVDoc> appList = new ArrayList<KVDoc>();
        ArrayList<KVDoc> serviceList = new ArrayList<KVDoc>();
        ArrayList<KVDoc> versionList = new ArrayList<KVDoc>();
        for (KVDoc kvDoc : resp.getData()) {
            Map<String, String> labelsMap;
            if (!StringUtils.isEmpty((CharSequence)kvDoc.getStatus()) && !kvDoc.getStatus().equals(STATUS_ENABLED) || !(labelsMap = kvDoc.getLabels()).containsKey(LABEL_APP) || !labelsMap.get(LABEL_APP).equals(KieConfig.INSTANCE.getAppName()) || !labelsMap.containsKey(LABEL_ENV) || !labelsMap.get(LABEL_ENV).equals(KieConfig.INSTANCE.getEnvironment())) continue;
            if (!labelsMap.containsKey(LABEL_SERVICE)) {
                appList.add(kvDoc);
            }
            if (!labelsMap.containsKey(LABEL_SERVICE) || !labelsMap.get(LABEL_SERVICE).equals(KieConfig.INSTANCE.getServiceName())) continue;
            if (!kvDoc.getLabels().containsKey(LABEL_VERSION)) {
                serviceList.add(kvDoc);
            }
            if (!labelsMap.containsKey(LABEL_VERSION) || !labelsMap.get(LABEL_VERSION).equals(KieConfig.INSTANCE.getVersion())) continue;
            versionList.add(kvDoc);
        }
        for (KVDoc kvDoc : appList) {
            resultMap.putAll(KieUtil.processValueType(kvDoc));
        }
        for (KVDoc kvDoc : serviceList) {
            resultMap.putAll(KieUtil.processValueType(kvDoc));
        }
        for (KVDoc kvDoc : versionList) {
            resultMap.putAll(KieUtil.processValueType(kvDoc));
        }
        return resultMap;
    }

    public static Map<String, Object> processValueType(KVDoc kvDoc) {
        ValueType valueType = KieUtil.parseValueType(kvDoc.getValueType());
        if (valueType == ValueType.YAML || valueType == ValueType.YML) {
            return Parser.findParser((String)"yaml").parse(kvDoc.getValue(), kvDoc.getKey(), true);
        }
        if (valueType == ValueType.PROPERTIES) {
            return Parser.findParser((String)"properties").parse(kvDoc.getValue(), kvDoc.getKey(), true);
        }
        return Parser.findParser((String)"raw").parse(kvDoc.getValue(), kvDoc.getKey(), true);
    }

    private static ValueType parseValueType(String valueType) {
        if (StringUtils.isEmpty((CharSequence)valueType)) {
            return ValueType.STRING;
        }
        try {
            return ValueType.valueOf(valueType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("read unrecognized value type {}", (Object)valueType);
            return ValueType.STRING;
        }
    }

    private static Map<String, String> toMap(String prefix, Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (!StringUtils.isEmpty((CharSequence)prefix)) {
                key = prefix + "." + key;
            }
            if (value != null) {
                result.put(key, value.trim());
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

