/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.archaius.sources;

import com.google.common.collect.ImmutableMap;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.kie.client.KieClient;
import org.apache.servicecomb.config.kie.client.KieConfig;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieConfigurationSourceImpl
implements ConfigCenterConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieConfigurationSourceImpl.class);
    private static final String KIE_CONFIG_URL_KEY = "servicecomb.kie.serverUri";
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>();
    private List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();
    private UpdateHandler updateHandler = new UpdateHandler();
    private KieClient kieClient;

    public int getOrder() {
        return 200;
    }

    public boolean isValidSource(Configuration localConfiguration) {
        if (localConfiguration.getProperty(KIE_CONFIG_URL_KEY) == null) {
            LOGGER.warn("Kie configuration source is not configured!");
            return false;
        }
        return true;
    }

    public void init(Configuration localConfiguration) {
        KieConfig.setFinalConfig((ConcurrentCompositeConfiguration)localConfiguration);
        this.kieClient = new KieClient(this.updateHandler);
        this.kieClient.refreshKieConfig();
    }

    public void destroy() {
        if (this.kieClient == null) {
            return;
        }
        this.kieClient.destroy();
    }

    public void addUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.add(watchedUpdateListener);
    }

    public void removeUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.remove(watchedUpdateListener);
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return this.valueCache;
    }

    private void updateConfiguration(WatchedUpdateResult result) {
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                LOGGER.error("Error in invoking WatchedUpdateListener", ex);
            }
        }
    }

    public class UpdateHandler {
        public void handle(String action, Map<String, Object> parseConfigs) {
            if (parseConfigs == null || parseConfigs.isEmpty()) {
                return;
            }
            Map configuration = ConfigMapping.getConvertedMap(parseConfigs);
            if ("create".equals(action)) {
                KieConfigurationSourceImpl.this.valueCache.putAll(configuration);
                KieConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)ImmutableMap.copyOf((Map)configuration), null, null));
            } else if ("set".equals(action)) {
                KieConfigurationSourceImpl.this.valueCache.putAll(configuration);
                KieConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, (Map)ImmutableMap.copyOf((Map)configuration), null));
            } else if ("delete".equals(action)) {
                configuration.keySet().forEach(KieConfigurationSourceImpl.this.valueCache::remove);
                KieConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, null, (Map)ImmutableMap.copyOf((Map)configuration)));
            } else {
                LOGGER.error("action: {} is invalid.", (Object)action);
                return;
            }
            LOGGER.warn("Config value cache changed: action:{}; item:{}", (Object)action, configuration.keySet());
        }
    }
}

