/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dtm;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.huaweicloud.dtm.DtmConfig;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtmProviderHandler
implements Handler {
    private static final Logger LOG = LoggerFactory.getLogger(DtmProviderHandler.class);
    private Method dtmContextImMethod;

    public DtmProviderHandler() {
        String className = DtmConfig.INSTANCE.getDtmContextClassName();
        try {
            Class<?> clazz = Class.forName(className);
            this.dtmContextImMethod = clazz.getMethod("setContextData", Map.class);
        }
        catch (Throwable e) {
            LOG.warn("Failed to init method {}#{}", new Object[]{className, "setContextData", e});
        }
    }

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        try {
            if (this.dtmContextImMethod != null) {
                String traceId = (String)invocation.getContext().get("X-B3-TraceId");
                invocation.getContext().put("X-Dtm-Trace-Id-Key", traceId);
                this.dtmContextImMethod.invoke(null, invocation.getContext());
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to execute method DTMContext#{}, please check", (Object)"setContextData", (Object)e);
        }
        invocation.next(asyncResp);
    }
}

