/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dtm;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.huaweicloud.dtm.DtmConfig;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtmConsumerHandler
implements Handler {
    private static final Logger LOG = LoggerFactory.getLogger(DtmConsumerHandler.class);
    private Method dtmContextExMethod;

    public DtmConsumerHandler() {
        String className = DtmConfig.INSTANCE.getDtmContextClassName();
        try {
            Class<?> clazz = Class.forName(className);
            this.dtmContextExMethod = clazz.getMethod("getContextData", new Class[0]);
        }
        catch (Throwable e) {
            LOG.warn("Failed to init method {}#{}", new Object[]{className, "getContextData", e});
        }
    }

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        try {
            Object context;
            if (this.dtmContextExMethod != null && (context = this.dtmContextExMethod.invoke(null, new Object[0])) instanceof Map) {
                invocation.getContext().putAll((Map)context);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to execute method DTMContext#{}, please check", (Object)"getContextData", (Object)e);
        }
        invocation.next(asyncResp);
    }
}

