/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.center.client;

import com.google.common.eventbus.EventBus;
import org.apache.servicecomb.config.center.client.ConfigCenterClient;
import org.apache.servicecomb.config.center.client.ConfigurationChangedEvent;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsRequest;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsResponse;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;

public class ConfigCenterManager
extends AbstractTask {
    private static final long POLL_INTERVAL = 15000L;
    private ConfigCenterClient configCenterClient;
    private final EventBus eventBus;
    private QueryConfigurationsRequest queryConfigurationsRequest;

    public ConfigCenterManager(ConfigCenterClient configCenterClient, EventBus eventBus) {
        super("config-center-configuration-task");
        this.configCenterClient = configCenterClient;
        this.eventBus = eventBus;
    }

    public void setQueryConfigurationsRequest(QueryConfigurationsRequest queryConfigurationsRequest) {
        this.queryConfigurationsRequest = queryConfigurationsRequest;
    }

    public void startConfigCenterManager() {
        this.startTask(new PollConfigurationTask());
    }

    class PollConfigurationTask
    implements Task {
        PollConfigurationTask() {
        }

        public void execute() {
            QueryConfigurationsResponse response = ConfigCenterManager.this.configCenterClient.queryConfigurations(ConfigCenterManager.this.queryConfigurationsRequest);
            if (response.isChanged()) {
                ConfigCenterManager.this.queryConfigurationsRequest.setRevision(response.getRevision());
                ConfigCenterManager.this.eventBus.post((Object)new ConfigurationChangedEvent(response.getConfigurations()));
            }
            ConfigCenterManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ConfigCenterManager.this, 15000L, (Task)new PollConfigurationTask()));
        }
    }
}

