/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProducerInvocationFlow {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerInvocationFlow.class);
    private final long startTime = System.nanoTime();
    private final InvocationCreator invocationCreator;
    protected final HttpServletRequestEx requestEx;
    protected final HttpServletResponseEx responseEx;

    public ProducerInvocationFlow(InvocationCreator invocationCreator) {
        this(invocationCreator, null, null);
    }

    public ProducerInvocationFlow(InvocationCreator invocationCreator, HttpServletRequestEx requestEx, HttpServletResponseEx responseEx) {
        this.invocationCreator = invocationCreator;
        this.requestEx = requestEx;
        this.responseEx = responseEx;
    }

    public void run() {
        ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenApply(v -> this.invocationCreator.create())).exceptionally(this::sendCreateInvocationException)).thenAccept(this::tryRunInvocation);
    }

    private void tryRunInvocation(Invocation invocation) {
        if (invocation == null) {
            return;
        }
        invocation.onStart(this.requestEx, this.startTime);
        ((CompletableFuture)invocation.getMicroserviceMeta().getFilterChain().onFilter(invocation).whenComplete((response, Throwable2) -> this.sendResponse(invocation, (Response)response))).whenComplete((response, Throwable2) -> this.finishInvocation(invocation, (Response)response, (Throwable)Throwable2));
    }

    private void finishInvocation(Invocation invocation, Response response, Throwable throwable) {
        invocation.onFinish(response);
        if (throwable == null) {
            return;
        }
        throwable = Exceptions.unwrap(throwable);
        if (this.requestEx == null) {
            LOGGER.error("Failed to finish invocation, operation:{}", (Object)invocation.getMicroserviceQualifiedName(), (Object)throwable);
            return;
        }
        LOGGER.error("Failed to finish invocation, operation:{}, request uri:{}", new Object[]{invocation.getMicroserviceQualifiedName(), this.requestEx.getRequestURI(), throwable});
    }

    protected abstract Invocation sendCreateInvocationException(Throwable var1);

    protected abstract void sendResponse(Invocation var1, Response var2);
}

