/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.config;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.core.filter.config.TransportFilterConfig;
import org.springframework.stereotype.Component;

@Component
public class TransportFiltersConfig {
    public static final String FILTER_CHAINS_PREFIX = "servicecomb.filter-chains.";
    public static final String ROOT = "servicecomb.filter-chains.transport-filters";
    private final Map<String, TransportFilterConfig> byName = new HashMap<String, TransportFilterConfig>();
    private final Configuration config = (Configuration)DynamicPropertyFactory.getBackingConfigurationSource();

    public void load() {
        this.config.getKeys(ROOT).forEachRemaining(this::loadOneChain);
    }

    private void loadOneChain(String qualifiedKey) {
        String qualifiedName = qualifiedKey.substring(ROOT.length() + 1);
        int dotIdx = qualifiedName.indexOf(46);
        String name = qualifiedName.substring(0, dotIdx);
        String transport = qualifiedName.substring(dotIdx + 1);
        this.byName.computeIfAbsent(name, key -> new TransportFilterConfig()).setTransportFilters(transport, this.config.getList(qualifiedKey));
    }

    public TransportFilterConfig getConfig(String name) {
        return this.byName.get(name);
    }
}

