/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.apache.servicecomb.foundation.bootstrap.BootStrapService;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class ConfigurationSpringInitializer
extends PropertyPlaceholderConfigurer
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSpringInitializer.class);
    public static final String EXTRA_CONFIG_SOURCE_PREFIX = "extraConfig-";
    private final List<BootStrapService> bootStrapServices = SPIServiceUtils.getSortedService(BootStrapService.class);

    public ConfigurationSpringInitializer() {
        this.setOrder(0x3FFFFFFF);
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    public void setEnvironment(Environment environment) {
        String environmentName = this.generateNameForEnvironment(environment);
        LOGGER.info("Environment received, will get configurations from [{}].", (Object)environmentName);
        Map<String, Object> extraConfig = this.getAllProperties(environment);
        this.addMicroserviceYAMLToSpring(environment);
        this.addMappingToString(environment);
        this.startupBootStrapService(environment);
        ConfigUtil.addExtraConfig((String)(EXTRA_CONFIG_SOURCE_PREFIX + environmentName), extraConfig);
        ConfigCenterConfigurationSource configCenterConfigurationSource = ConfigUtil.installDynamicConfig();
        this.addDynamicConfigurationToSpring(environment, configCenterConfigurationSource);
    }

    private void startupBootStrapService(Environment environment) {
        this.bootStrapServices.forEach(bootStrapService -> bootStrapService.startup(environment));
    }

    private void addMicroserviceYAMLToSpring(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment ce = (ConfigurableEnvironment)environment;
            final MicroserviceConfigLoader loader = new MicroserviceConfigLoader();
            loader.loadAndSort();
            ce.getPropertySources().addLast((PropertySource)new EnumerablePropertySource<MicroserviceConfigLoader>("microservice.yaml", loader){
                private boolean parsed;
                private Map<String, Object> values;
                private String[] propertyNames;
                {
                    super(x0, (Object)x1);
                    this.parsed = false;
                    this.values = null;
                    this.propertyNames = null;
                }

                public String[] getPropertyNames() {
                    if (!this.parsed) {
                        this.parseData();
                    }
                    return this.propertyNames;
                }

                public Object getProperty(String s) {
                    if (!this.parsed) {
                        this.parseData();
                    }
                    return this.values.get(s);
                }

                private void parseData() {
                    this.values = new HashMap<String, Object>();
                    loader.getConfigModels().forEach(configModel -> this.values.putAll(YAMLUtil.retrieveItems((String)"", (Map)configModel.getConfig())));
                    this.propertyNames = this.values.keySet().toArray(new String[this.values.size()]);
                }
            });
        }
    }

    private void addMappingToString(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment ce = (ConfigurableEnvironment)environment;
            Map mappings = ConfigMapping.getConvertedMap((Environment)environment);
            ce.getPropertySources().addFirst((PropertySource)new MapPropertySource("mapping.yaml", mappings));
        }
    }

    private void addDynamicConfigurationToSpring(Environment environment, ConfigCenterConfigurationSource configCenterConfigurationSource) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment ce = (ConfigurableEnvironment)environment;
            if (configCenterConfigurationSource != null) {
                try {
                    ce.getPropertySources().addFirst((PropertySource)new MapPropertySource("dynamic-source", configCenterConfigurationSource.getCurrentData()));
                }
                catch (Exception e) {
                    LOGGER.warn("set up spring property source failed. msg: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties = super.mergeProperties();
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        Iterator iterator = config.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = config.getProperty(key);
            properties.put(key, value);
        }
        return properties;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String propertyValue = super.resolvePlaceholder(placeholder, props);
        if (propertyValue == null) {
            return DynamicPropertyFactory.getInstance().getStringProperty(placeholder, null).get();
        }
        return propertyValue;
    }

    private String generateNameForEnvironment(Environment environment) {
        String environmentName = environment.getProperty("spring.config.name");
        if (!StringUtils.isEmpty((Object)environmentName)) {
            return environmentName;
        }
        environmentName = environment.getProperty("spring.application.name");
        if (!StringUtils.isEmpty((Object)environmentName)) {
            return environmentName;
        }
        return environment.getClass().getName() + "@" + environment.hashCode();
    }

    private Map<String, Object> getAllProperties(Environment environment) {
        HashMap<String, Object> configFromSpringBoot = new HashMap<String, Object>();
        if (!(environment instanceof ConfigurableEnvironment)) {
            return configFromSpringBoot;
        }
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
        if (this.ignoreResolveFailure()) {
            configurableEnvironment.setIgnoreUnresolvableNestedPlaceholders(true);
        }
        for (PropertySource propertySource : configurableEnvironment.getPropertySources()) {
            this.getProperties(configurableEnvironment, propertySource, configFromSpringBoot);
        }
        return configFromSpringBoot;
    }

    private void getProperties(ConfigurableEnvironment environment, PropertySource<?> propertySource, Map<String, Object> configFromSpringBoot) {
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource compositePropertySource = (CompositePropertySource)propertySource;
            compositePropertySource.getPropertySources().forEach(ps -> this.getProperties(environment, (PropertySource<?>)ps, configFromSpringBoot));
            return;
        }
        if (propertySource instanceof EnumerablePropertySource) {
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                try {
                    configFromSpringBoot.put(propertyName, environment.getProperty(propertyName, Object.class));
                }
                catch (Exception e) {
                    throw new RuntimeException("set up spring property source failed.If you still want to start up the application and ignore errors, you can set servicecomb.config.ignoreResolveFailure to true.", e);
                }
            }
            return;
        }
        LOGGER.debug("a none EnumerablePropertySource is ignored, propertySourceName = [{}]", (Object)propertySource.getName());
    }

    private boolean ignoreResolveFailure() {
        return ConfigUtil.createLocalConfig().getBoolean("servicecomb.config.ignoreResolveFailure", false);
    }
}

