/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.config;

import com.netflix.config.DynamicPropertyFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;

public class ServiceRegistryConfigCustomizer {
    private ServiceRegistryConfig original;

    private ServiceRegistryConfigCustomizer(ServiceRegistryConfig original) {
        this.original = original;
    }

    public static ServiceRegistryConfigCustomizer from(ServiceRegistryConfig original) {
        return new ServiceRegistryConfigCustomizer(original);
    }

    public ServiceRegistryConfigCustomizer setClientName(String clientName) {
        this.original.setClientName(clientName);
        return this;
    }

    public ServiceRegistryConfigCustomizer setWatchClientName(String watchClientName) {
        this.original.setWatchClientName(watchClientName);
        return this;
    }

    public ServiceRegistryConfigCustomizer addressListFromConfiguration(String configuration) {
        String address = DynamicPropertyFactory.getInstance().getStringProperty(configuration, null).get();
        if (address == null) {
            throw new IllegalStateException("service center address is required.");
        }
        String[] urls = address.split(",");
        List<String> uriList = Arrays.asList(urls);
        ArrayList<IpPort> ipPortList = new ArrayList<IpPort>();
        uriList.forEach(anUriList -> {
            try {
                URI uri = new URI(anUriList.trim());
                if ("https".equals(uri.getScheme())) {
                    this.original.setSsl(true);
                }
                ipPortList.add(NetUtils.parseIpPort((URI)uri));
            }
            catch (Exception e) {
                throw new IllegalStateException("service center address is required.", e);
            }
        });
        this.original.setIpPort(ipPortList);
        return this;
    }

    public ServiceRegistryConfig get() {
        return this.original;
    }
}

