/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.net;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);
    private static final String IPV4_KEY = "_v4";
    private static final String IPV6_KEY = "_v6";
    private static Map<String, InetAddress> allInterfaceAddresses = new HashMap<String, InetAddress>();
    private static String hostName;
    private static String hostAddress;
    private static String hostAddressIpv6;

    private static void doGetHostNameAndHostAddress() {
        block4: {
            try {
                NetUtils.doGetAddressFromNetworkInterface();
                InetAddress localHost = InetAddress.getLocalHost();
                hostName = localHost.getHostName();
                if ((localHost.isAnyLocalAddress() || localHost.isLoopbackAddress() || localHost.isMulticastAddress()) && !allInterfaceAddresses.isEmpty()) {
                    allInterfaceAddresses.forEach((key, val) -> {
                        if (key.endsWith(IPV4_KEY)) {
                            hostAddress = val.getHostAddress();
                            LOGGER.warn("cannot find a proper ipv4 host address, choose {} , may not be correct.", (Object)hostAddress);
                        } else {
                            hostAddressIpv6 = val.getHostAddress();
                            int index = hostAddressIpv6.indexOf("%");
                            if (index > 0) {
                                hostAddressIpv6 = hostAddressIpv6.substring(0, index);
                            }
                            LOGGER.warn("cannot find a proper ipv6 host address, choose {} , may not be correct.", (Object)hostAddressIpv6);
                        }
                    });
                } else {
                    LOGGER.info("get localhost address: {}", (Object)localHost.getHostAddress());
                    hostAddress = localHost.getHostAddress();
                }
                LOGGER.info("add host name from localhost:" + hostName + ",host address:" + hostAddress);
            }
            catch (Exception e) {
                LOGGER.error("got exception when trying to get addresses:", (Throwable)e);
                if (allInterfaceAddresses.size() < 1) break block4;
                InetAddress entry = allInterfaceAddresses.entrySet().iterator().next().getValue();
                hostName = entry.getHostName();
                hostAddress = entry.getHostAddress();
                LOGGER.info("add host name from interfaces:" + hostName + ",host address:" + hostAddress);
            }
        }
    }

    private NetUtils() {
    }

    private static void doGetAddressFromNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> iterNetwork = NetworkInterface.getNetworkInterfaces();
        while (iterNetwork.hasMoreElements()) {
            NetworkInterface network = iterNetwork.nextElement();
            if (!network.isUp() || network.isLoopback() || network.isVirtual()) continue;
            Enumeration<InetAddress> iterAddress = network.getInetAddresses();
            while (iterAddress.hasMoreElements()) {
                InetAddress address = iterAddress.nextElement();
                if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isMulticastAddress()) continue;
                if (Inet4Address.class.isInstance(address)) {
                    LOGGER.info("add network interface name:" + network.getName() + ",ipv4 host address:" + address.getHostAddress());
                    allInterfaceAddresses.put(network.getName() + IPV4_KEY, address);
                    continue;
                }
                if (!Inet6Address.class.isInstance(address)) continue;
                LOGGER.info("add network interface name:" + network.getName() + ",ipv6 host address:" + address.getHostAddress());
                allInterfaceAddresses.put(network.getName() + IPV6_KEY, address);
            }
        }
    }

    public static IpPort parseIpPort(String address) {
        if (address == null) {
            return null;
        }
        URI uri = URI.create("http://" + address);
        return NetUtils.parseIpPort(uri, true);
    }

    public static IpPort parseIpPort(URI uri) {
        return NetUtils.parseIpPort(uri, false);
    }

    public static IpPort parseIpPort(URI uri, boolean ignorePortUndefined) {
        if (null == uri.getHost()) {
            throw new IllegalArgumentException("Illegal uri: [" + uri + "]");
        }
        IpPort ipPort = new IpPort(uri.getHost(), uri.getPort());
        if (-1 != ipPort.getPort() || ignorePortUndefined) {
            return ipPort;
        }
        if (uri.getScheme().equals("http")) {
            ipPort.setPort(80);
        }
        if (uri.getScheme().equals("https")) {
            ipPort.setPort(443);
        }
        return ipPort;
    }

    public static IpPort parseIpPortFromURI(String uriAddress) {
        if (uriAddress == null) {
            return null;
        }
        try {
            return NetUtils.parseIpPort(new URI(uriAddress));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static IpPort parseIpPort(String scheme, String authority) {
        if (authority == null) {
            return null;
        }
        return NetUtils.parseIpPort(URI.create(scheme + "://" + authority));
    }

    public static String getRealListenAddress(String schema, String address) {
        if (address == null) {
            return null;
        }
        try {
            URI originalURI = new URI(schema + "://" + address);
            IpPort ipPort = NetUtils.parseIpPort(originalURI);
            if (ipPort == null) {
                LOGGER.error("address {} is not valid.", (Object)address);
                return null;
            }
            return originalURI.toString();
        }
        catch (URISyntaxException e) {
            LOGGER.error("address {} is not valid.", (Object)address);
            return null;
        }
    }

    public static String getHostName() {
        if (hostName == null) {
            NetUtils.doGetHostNameAndHostAddress();
        }
        return hostName;
    }

    public static String getHostAddress() {
        if (hostAddress == null) {
            NetUtils.doGetHostNameAndHostAddress();
        }
        return hostAddress;
    }

    public static String getIpv6HostAddress() {
        if (hostAddressIpv6 == null) {
            NetUtils.doGetHostNameAndHostAddress();
        }
        return hostAddressIpv6;
    }

    public static InetAddress getInterfaceAddress(String interfaceName) {
        return allInterfaceAddresses.get(interfaceName);
    }

    public static InetAddress ensureGetInterfaceAddress(String interfaceName) {
        InetAddress address = allInterfaceAddresses.get(interfaceName);
        if (address == null) {
            throw new IllegalArgumentException("Can not find address for interface name: " + interfaceName);
        }
        return address;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canTcpListen(InetAddress address, int port) {
        try (ServerSocket ss = new ServerSocket(port, 0, address);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String humanReadableBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.3f%c", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    static {
        NetUtils.doGetHostNameAndHostAddress();
    }
}

