/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import com.google.common.base.Joiner;
import com.netflix.config.ConcurrentCompositeConfiguration;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.deployment.Deployment;

public final class ConfigCenterConfig {
    public static final ConfigCenterConfig INSTANCE = new ConfigCenterConfig();
    private static ConcurrentCompositeConfiguration finalConfig;
    private static final String AUTO_DISCOVERY_ENABLED = "servicecomb.service.registry.autodiscovery";
    private static final String REFRESH_MODE = "servicecomb.config.client.refreshMode";
    private static final String REFRESH_PORT = "servicecomb.config.client.refreshPort";
    private static final String TENANT_NAME = "servicecomb.config.client.tenantName";
    private static final String DOMAIN_NAME = "servicecomb.config.client.domainName";
    private static final String TOKEN_NAME = "servicecomb.config.client.token";
    private static final String URI_API_VERSION = "servicecomb.config.client.api.version";
    private static final String REFRESH_INTERVAL = "servicecomb.config.client.refresh_interval";
    private static final String FIRST_REFRESH_INTERVAL = "servicecomb.config.client.first_refresh_interval";
    public static final String CONNECTION_TIME_OUT = "servicecomb.config.client.timeout.connection";
    public static final String EVENT_LOOP_SIZE = "servicecomb.config.client.eventLoopSize";
    public static final String VERTICAL_INSTANCE_COUNT = "servicecomb.config.client.verticalInstanceCount";
    public static final String IDLE_TIMEOUT_IN_SECONDES = "servicecomb.config.client.idleTimeoutInSeconds";
    private static final int DEFAULT_REFRESH_MODE = 0;
    private static final int DEFAULT_REFRESH_PORT = 30104;
    private static final int DEFAULT_REFRESH_INTERVAL = 30000;
    private static final int DEFAULT_FIRST_REFRESH_INTERVAL = 0;

    private ConfigCenterConfig() {
    }

    public static void setConcurrentCompositeConfiguration(ConcurrentCompositeConfiguration config) {
        finalConfig = config;
    }

    public static ConcurrentCompositeConfiguration getConcurrentCompositeConfiguration() {
        return finalConfig;
    }

    public int getRefreshMode() {
        return finalConfig.getInt(REFRESH_MODE, 0);
    }

    public int getRefreshPort() {
        return finalConfig.getInt(REFRESH_PORT, 30104);
    }

    public String getTenantName() {
        return finalConfig.getString(TENANT_NAME, "default");
    }

    public String getDomainName() {
        return finalConfig.getString(DOMAIN_NAME, "default");
    }

    public String getToken() {
        return finalConfig.getString(TOKEN_NAME, null);
    }

    public String getApiVersion() {
        return finalConfig.getString(URI_API_VERSION, "v3");
    }

    public int getRefreshInterval() {
        return finalConfig.getInt(REFRESH_INTERVAL, 30000);
    }

    public int getFirstRefreshInterval() {
        return finalConfig.getInt(FIRST_REFRESH_INTERVAL, 0);
    }

    public Boolean isProxyEnable() {
        return finalConfig.getBoolean("servicecomb.proxy.enable", false);
    }

    public String getProxyHost() {
        return finalConfig.getString("servicecomb.proxy.host", "127.0.0.1");
    }

    public int getProxyPort() {
        return finalConfig.getInt("servicecomb.proxy.port", 8080);
    }

    public String getProxyUsername() {
        return finalConfig.getString("servicecomb.proxy.username", null);
    }

    public String getProxyPasswd() {
        return finalConfig.getString("servicecomb.proxy.passwd", null);
    }

    public String getServiceName() {
        String o;
        String serviceVersion;
        String service = BootStrapProperties.readServiceName((Configuration)finalConfig);
        String appName = BootStrapProperties.readApplication((Configuration)finalConfig);
        if (appName != null) {
            service = service + "@" + appName;
        }
        if ((serviceVersion = BootStrapProperties.readServiceVersion((Configuration)finalConfig)) != null) {
            service = service + "#" + serviceVersion;
        }
        if ((o = BootStrapProperties.readServiceInstanceTags((Configuration)finalConfig)) == null) {
            return service;
        }
        String tags = o instanceof List ? Joiner.on((String)",").join((Iterable)((List)((Object)o))) : o.toString();
        service = service + "!" + tags;
        return service;
    }

    public List<String> getServerUri() {
        return Deployment.getSystemBootStrapInfo((String)"ConfigCenter").getAccessURL();
    }

    public boolean getAutoDiscoveryEnabled() {
        return finalConfig.getBoolean(AUTO_DISCOVERY_ENABLED, false);
    }

    public int getConnectionTimeout() {
        return finalConfig.getInt(CONNECTION_TIME_OUT, 1000);
    }

    public int getEventLoopSize() {
        return finalConfig.getInt(EVENT_LOOP_SIZE, 2);
    }

    public int getVerticalInstanceCount() {
        return finalConfig.getInt(VERTICAL_INSTANCE_COUNT, 1);
    }

    public int getIdleTimeoutInSeconds() {
        return finalConfig.getInt(IDLE_TIMEOUT_IN_SECONDES, 60);
    }

    public String getEnvironment() {
        return BootStrapProperties.readServiceEnvironment((Configuration)finalConfig);
    }
}

