/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.apache.servicecomb.service.center.client.AddressManager;
import org.apache.servicecomb.service.center.client.ServiceCenterOperation;
import org.apache.servicecomb.service.center.client.ServiceCenterRawClient;
import org.apache.servicecomb.service.center.client.exception.OperationException;
import org.apache.servicecomb.service.center.client.model.CreateMicroserviceInstanceRequest;
import org.apache.servicecomb.service.center.client.model.CreateMicroserviceRequest;
import org.apache.servicecomb.service.center.client.model.CreateSchemaRequest;
import org.apache.servicecomb.service.center.client.model.FindMicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.GetSchemaListResponse;
import org.apache.servicecomb.service.center.client.model.GetSchemaResponse;
import org.apache.servicecomb.service.center.client.model.HeartbeatsRequest;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceResponse;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceStatus;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.MicroserviceResponse;
import org.apache.servicecomb.service.center.client.model.MicroservicesResponse;
import org.apache.servicecomb.service.center.client.model.ModifySchemasRequest;
import org.apache.servicecomb.service.center.client.model.RegisteredMicroserviceInstanceResponse;
import org.apache.servicecomb.service.center.client.model.RegisteredMicroserviceResponse;
import org.apache.servicecomb.service.center.client.model.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterClient
implements ServiceCenterOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterClient.class);
    private ServiceCenterRawClient httpClient;

    public ServiceCenterClient(ServiceCenterRawClient httpClient) {
        this.httpClient = httpClient;
    }

    public ServiceCenterClient(AddressManager addressManager, HttpConfiguration.SSLProperties sslProperties, HttpConfiguration.AKSKProperties akskProperties, String tenantName, Map<String, String> extraGlobalHeaders) {
        HttpTransport httpTransport = HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)sslProperties, (HttpConfiguration.AKSKProperties)akskProperties);
        httpTransport.addHeaders(extraGlobalHeaders);
        this.httpClient = new ServiceCenterRawClient.Builder().setTenantName(tenantName).setAddressManager(addressManager).setHttpTransport(httpTransport).build();
    }

    @Override
    public MicroserviceInstancesResponse getServiceCenterInstances() {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/health", null, null);
            if (response.getStatusCode() == 200) {
                return (MicroserviceInstancesResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstancesResponse.class);
            }
            throw new OperationException("get service-center instances fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service-center instances fails", e);
        }
    }

    @Override
    public RegisteredMicroserviceResponse registerMicroservice(Microservice microservice) {
        try {
            CreateMicroserviceRequest request = new CreateMicroserviceRequest();
            request.setService(microservice);
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices", null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                return (RegisteredMicroserviceResponse)HttpUtils.deserialize((String)response.getContent(), RegisteredMicroserviceResponse.class);
            }
            throw new OperationException("register service fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("register service fails", e);
        }
    }

    @Override
    public MicroservicesResponse getMicroserviceList() {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices", null, null);
            if (response.getStatusCode() == 200) {
                return (MicroservicesResponse)HttpUtils.deserialize((String)response.getContent(), MicroservicesResponse.class);
            }
            throw new OperationException("get service List fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service List fails", e);
        }
    }

    @Override
    public RegisteredMicroserviceResponse queryServiceId(Microservice microservice) {
        try {
            URIBuilder uriBuilder = new URIBuilder("/registry/existence");
            uriBuilder.setParameter("type", "microservice");
            uriBuilder.setParameter("appId", microservice.getAppId());
            uriBuilder.setParameter("serviceName", microservice.getServiceName());
            uriBuilder.setParameter("version", microservice.getVersion());
            uriBuilder.setParameter("env", microservice.getEnvironment());
            HttpResponse response = this.httpClient.getHttpRequest(uriBuilder.build().toString(), null, null);
            if (response.getStatusCode() == 200) {
                return (RegisteredMicroserviceResponse)HttpUtils.deserialize((String)response.getContent(), RegisteredMicroserviceResponse.class);
            }
            LOGGER.info("Query serviceId fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
            return null;
        }
        catch (IOException e) {
            throw new OperationException("query serviceId fails", e);
        }
        catch (URISyntaxException e) {
            throw new OperationException("build url failed.", e);
        }
    }

    @Override
    public Microservice getMicroserviceByServiceId(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId, null, null);
            if (response.getStatusCode() == 200) {
                MicroserviceResponse microserviceResponse = (MicroserviceResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceResponse.class);
                return microserviceResponse.getService();
            }
            throw new OperationException("get service message fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service message fails", e);
        }
    }

    @Override
    public RegisteredMicroserviceInstanceResponse registerMicroserviceInstance(MicroserviceInstance instance) {
        try {
            CreateMicroserviceInstanceRequest request = new CreateMicroserviceInstanceRequest();
            request.setInstance(instance);
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices/" + instance.getServiceId() + "/instances", null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                return (RegisteredMicroserviceInstanceResponse)HttpUtils.deserialize((String)response.getContent(), RegisteredMicroserviceInstanceResponse.class);
            }
            throw new OperationException("register service instance fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("register service instance fails", e);
        }
    }

    @Override
    public FindMicroserviceInstancesResponse findMicroserviceInstance(String consumerId, String appId, String serviceName, String versionRule, String revision) {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-ConsumerId", consumerId);
            HttpResponse response = this.httpClient.getHttpRequest("/registry/instances?appId=" + URLEncoder.encode(appId, "UTF-8") + "&serviceName=" + HttpUtils.encodeURLParam((String)serviceName) + "&version=" + HttpUtils.encodeURLParam((String)versionRule) + "&rev=" + HttpUtils.encodeURLParam((String)revision), headers, null);
            FindMicroserviceInstancesResponse result = new FindMicroserviceInstancesResponse();
            if (response.getStatusCode() == 200) {
                result.setModified(true);
                result.setRevision(response.getHeader("X-Resource-Revision"));
                result.setMicroserviceInstancesResponse((MicroserviceInstancesResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstancesResponse.class));
                return result;
            }
            if (response.getStatusCode() == 304) {
                result.setModified(false);
                return result;
            }
            throw new OperationException("get service instances list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instances list fails", e);
        }
    }

    @Override
    public MicroserviceInstancesResponse getMicroserviceInstanceList(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/instances", null, null);
            if (response.getStatusCode() == 200) {
                return (MicroserviceInstancesResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstancesResponse.class);
            }
            throw new OperationException("get service instances list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instances list fails", e);
        }
    }

    @Override
    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId, null, null);
            if (response.getStatusCode() == 200) {
                MicroserviceInstanceResponse instanceResponse = (MicroserviceInstanceResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstanceResponse.class);
                return instanceResponse.getInstance();
            }
            throw new OperationException("get service instance message fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instance message fails", e);
        }
    }

    public void deleteMicroserviceInstance(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.deleteHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId, null, null);
            if (response.getStatusCode() != 200) {
                throw new OperationException("delete service instance fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
            }
            LOGGER.info("DELETE SERVICE INSTANCE OK");
        }
        catch (IOException e) {
            throw new OperationException("delete service instance fails", e);
        }
    }

    @Override
    public boolean updateMicroserviceInstanceStatus(String serviceId, String instanceId, MicroserviceInstanceStatus status) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId + "/status?value=" + (Object)((Object)status), null, null);
            if (response.getStatusCode() == 200) {
                LOGGER.info("UPDATE STATUS OK");
                return true;
            }
            throw new OperationException("update service instance status fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service instance status fails", e);
        }
    }

    public void sendHeartBeats(HeartbeatsRequest heartbeatsRequest) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/heartbeats", null, HttpUtils.serialize((Object)heartbeatsRequest));
            if (response.getStatusCode() != 200) {
                throw new OperationException("heartbeats fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
            }
            LOGGER.info("HEARTBEATS SUCCESS");
        }
        catch (IOException e) {
            throw new OperationException("heartbeats fails ", e);
        }
    }

    @Override
    public boolean sendHeartBeat(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId + "/heartbeat", null, null);
            if (response.getStatusCode() == 200) {
                return true;
            }
            throw new OperationException("heartbeats fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("heartbeats fails ", e);
        }
    }

    public List<SchemaInfo> getServiceSchemasList(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/schemas", null, null);
            if (response.getStatusCode() == 200) {
                GetSchemaListResponse getSchemaResponse = (GetSchemaListResponse)HttpUtils.deserialize((String)response.getContent(), GetSchemaListResponse.class);
                return getSchemaResponse.getSchemas();
            }
            throw new OperationException("get service schemas list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service schemas list fails", e);
        }
    }

    public String getServiceSchemaContext(String serviceId, String schemaId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaId, null, null);
            if (response.getStatusCode() == 200) {
                GetSchemaResponse getSchemaResponse = (GetSchemaResponse)HttpUtils.deserialize((String)response.getContent(), GetSchemaResponse.class);
                return getSchemaResponse.getSchema();
            }
            throw new OperationException("get service schema context fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service schemas context fails", e);
        }
    }

    @Override
    public boolean registerSchema(String serviceId, String schemaId, CreateSchemaRequest schema) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaId, null, HttpUtils.serialize((Object)schema));
            if (response.getStatusCode() == 200) {
                return true;
            }
            throw new OperationException("update service schema fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service schema fails", e);
        }
    }

    @Override
    public boolean updateServiceSchemaContext(String serviceId, SchemaInfo schemaInfo) {
        try {
            CreateSchemaRequest request = new CreateSchemaRequest();
            request.setSchema(schemaInfo.getSchema());
            request.setSummary(schemaInfo.getSummary());
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaInfo.getSchemaId(), null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                return true;
            }
            throw new OperationException("update service schema fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service schema fails", e);
        }
    }

    @Override
    public boolean batchUpdateServiceSchemaContext(String serviceId, ModifySchemasRequest modifySchemasRequest) {
        try {
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices/" + serviceId + "/schemas", null, HttpUtils.serialize((Object)modifySchemasRequest));
            if (response.getStatusCode() == 200) {
                LOGGER.info("UPDATE SCHEMA OK");
                return true;
            }
            throw new OperationException("update service schema fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service schema fails", e);
        }
    }
}

