/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common.auth;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKSKHeaderExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(AKSKHeaderExtension.class);
    protected static final String DEFAULT_SECRET_AUTH_PATH = "/opt/CSE/etc/auth";
    protected static final String DEFAULT_SECRET_AUTH_NAME = ".dockerconfigjson";
    private static final int EXPECTED_ARR_LENGTH = 2;
    private boolean runOverHWC = !StringUtils.isEmpty((CharSequence)System.getenv("KUBERNETES_SERVICE_HOST"));
    private Map<String, String> defaultAuthHeaders = Collections.emptyMap();
    private boolean loaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getHeaders() {
        if (!this.runOverHWC) {
            return this.defaultAuthHeaders;
        }
        if (!this.loaded) {
            AKSKHeaderExtension aKSKHeaderExtension = this;
            synchronized (aKSKHeaderExtension) {
                if (!this.loaded) {
                    this.createAuthHeaders();
                }
            }
        }
        return this.defaultAuthHeaders;
    }

    public abstract void createAuthHeaders();

    protected void decode(JsonNode authNode) throws IOException {
        if (authNode == null) {
            return;
        }
        HashMap<String, String> authHeaders = new HashMap<String, String>();
        String authStr = authNode.asText();
        String authBase64Decode = new String(Base64.decodeBase64((String)authStr), "UTF-8");
        String[] auths = authBase64Decode.split("@");
        String[] akAndShaAkSk = auths[1].split(":");
        if (auths.length != 2 || akAndShaAkSk.length != 2) {
            LOGGER.error("get docker config failed. The data is not valid cause of unexpected format");
            return;
        }
        String project = auths[0];
        String ak = akAndShaAkSk[0];
        String shaAkSk = akAndShaAkSk[1];
        authHeaders.put("X-Service-AK", ak);
        authHeaders.put("X-Service-ShaAKSK", shaAkSk);
        authHeaders.put("X-Service-Project", project);
        this.defaultAuthHeaders = authHeaders;
        this.loaded = true;
    }
}

