/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLManager;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportImpl;

public class HttpTransportFactory {
    public static final int CONNECT_TIMEOUT = 5000;
    public static final int CONNECTION_REQUEST_TIMEOUT = 5000;
    public static final int SOCKET_TIMEOUT = 5000;
    public static final int MAX_TOTAL = 100;
    public static final int DEFAULT_MAX_PER_ROUTE = 10;

    private HttpTransportFactory() {
    }

    public static HttpTransport createHttpTransport(HttpConfiguration.SSLProperties sslProperties, HttpConfiguration.AKSKProperties akskProperties) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        RegistryBuilder builder = RegistryBuilder.create();
        builder.register("http", (Object)PlainConnectionSocketFactory.INSTANCE);
        if (sslProperties.isEnabled()) {
            builder.register("https", (Object)new SSLConnectionSocketFactory(SSLManager.createSSLContext((SSLOption)sslProperties.getSslOption(), (SSLCustom)sslProperties.getSslCustom()), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        }
        Registry connectionSocketFactoryRegistry = builder.build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(10);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).disableCookieManagement();
        return new HttpTransportImpl((HttpClient)httpClientBuilder.build(), akskProperties);
    }
}

