/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.http.client.common.HttpUtils;

public interface HttpConfiguration {

    public static class AKSKProperties {
        private boolean enabled;
        private String accessKey;
        private String secretKey;
        private String cipher;
        private String project;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            if ("ShaAKSKCipher".equalsIgnoreCase(this.cipher)) {
                return this.secretKey;
            }
            try {
                return HttpUtils.sha256Encode(this.secretKey, this.accessKey);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not able to encode ak sk.", e);
            }
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getCipher() {
            return this.cipher;
        }

        public void setCipher(String cipher) {
            this.cipher = cipher;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }
    }

    public static class SSLProperties {
        private boolean enabled;
        private SSLOption sslOption;
        private SSLCustom sslCustom;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public SSLOption getSslOption() {
            return this.sslOption;
        }

        public void setSslOption(SSLOption sslOption) {
            this.sslOption = sslOption;
        }

        public SSLCustom getSslCustom() {
            return this.sslCustom;
        }

        public void setSslCustom(SSLCustom sslCustom) {
            this.sslCustom = sslCustom;
        }
    }
}

