/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import io.vertx.core.http.HttpClientRequest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.config.kie.archaius.sources.KieConfigurationSourceImpl;
import org.apache.servicecomb.config.kie.client.ConfigKieHttpClientOptionsSPI;
import org.apache.servicecomb.config.kie.client.ConnFailEvent;
import org.apache.servicecomb.config.kie.client.ConnSuccEvent;
import org.apache.servicecomb.config.kie.client.KieConfig;
import org.apache.servicecomb.config.kie.client.KieUtil;
import org.apache.servicecomb.config.kie.client.KieWatcher;
import org.apache.servicecomb.config.kie.model.KVResponse;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieClient.class);
    private ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("org.apache.servicecomb.config.kie");
        thread.setDaemon(true);
        return thread;
    });
    private static final long PULL_REQUEST_TIME_OUT_IN_MILLIS = 10000L;
    private static final long LONG_POLLING_REQUEST_TIME_OUT_IN_MILLIS = 60000L;
    private static AtomicBoolean IS_FIRST_PULL = new AtomicBoolean(true);
    private static final int LONG_POLLING_WAIT_TIME_IN_SECONDS = 30;
    private static String revision = "0";
    private static final KieConfig KIE_CONFIG = KieConfig.INSTANCE;
    private final int refreshInterval = KIE_CONFIG.getRefreshInterval();
    private final int firstRefreshInterval = KIE_CONFIG.getFirstRefreshInterval();
    private final boolean enableLongPolling = KIE_CONFIG.enableLongPolling();
    private final String serviceUri = KIE_CONFIG.getServerUri();

    public KieClient(KieConfigurationSourceImpl.UpdateHandler updateHandler) {
        HttpClients.addNewClientPoolManager((HttpClientOptionsSPI)new ConfigKieHttpClientOptionsSPI());
        KieWatcher.INSTANCE.setUpdateHandler(updateHandler);
    }

    public void refreshKieConfig() {
        if (this.enableLongPolling) {
            this.EXECUTOR.execute(new ConfigRefresh(this.serviceUri));
        } else {
            this.EXECUTOR.scheduleWithFixedDelay(new ConfigRefresh(this.serviceUri), this.firstRefreshInterval, this.refreshInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void destroy() {
        if (this.EXECUTOR != null) {
            this.EXECUTOR.shutdown();
            this.EXECUTOR = null;
        }
    }

    class ConfigRefresh
    implements Runnable {
        private final String serviceUri;

        ConfigRefresh(String serviceUris) {
            this.serviceUri = serviceUris;
        }

        @Override
        public void run() {
            try {
                CountDownLatch latch = new CountDownLatch(1);
                this.refreshConfig(latch);
                latch.await();
            }
            catch (Throwable e) {
                LOGGER.error("client refresh thread exception ", e);
            }
            if (KieClient.this.enableLongPolling) {
                KieClient.this.EXECUTOR.execute(this);
            }
        }

        void refreshConfig(CountDownLatch latch) {
            long timeout;
            String path = "/v1/" + KieConfig.INSTANCE.getDomainName() + "/kie/kv?label=app:" + KieConfig.INSTANCE.getAppName() + "&revision=" + revision;
            if (KieClient.this.enableLongPolling && !IS_FIRST_PULL.get()) {
                path = path + "&wait=30s";
                timeout = 60000L;
            } else {
                IS_FIRST_PULL.compareAndSet(true, false);
                timeout = 10000L;
            }
            String finalPath = path;
            HttpClients.getClient((String)"config-kie").runOnContext(client -> {
                IpPort ipPort = NetUtils.parseIpPortFromURI((String)this.serviceUri);
                HttpClientRequest request = client.get(ipPort.getPort(), ipPort.getHostOrIp(), finalPath, rsp -> {
                    if (rsp.statusCode() == 200) {
                        revision = rsp.getHeader("X-Kie-Revision");
                        rsp.bodyHandler(buf -> {
                            try {
                                Map<String, Object> resMap = KieUtil.getConfigByLabel((KVResponse)JsonUtils.OBJ_MAPPER.readValue(buf.toString(), KVResponse.class));
                                KieWatcher.INSTANCE.refreshConfigItems(resMap);
                                EventManager.post((Object)new ConnSuccEvent());
                            }
                            catch (IOException e) {
                                EventManager.post((Object)new ConnFailEvent("config update result parse fail " + e.getMessage()));
                                LOGGER.error("Config update from {} failed. Error message is [{}].", (Object)this.serviceUri, (Object)e.getMessage());
                            }
                            latch.countDown();
                        });
                    } else if (rsp.statusCode() == 304) {
                        EventManager.post((Object)new ConnSuccEvent());
                        latch.countDown();
                    } else {
                        EventManager.post((Object)new ConnFailEvent("fetch config fail"));
                        LOGGER.error("Config update from {} failed. Error code is {}, error message is [{}].", new Object[]{this.serviceUri, rsp.statusCode(), rsp.statusMessage()});
                        latch.countDown();
                    }
                }).setTimeout(timeout);
                request.exceptionHandler(e -> {
                    EventManager.post((Object)new ConnFailEvent("fetch config fail"));
                    LOGGER.error("Config update from {} failed. Error message is [{}].", (Object)this.serviceUri, (Object)e.getMessage());
                    latch.countDown();
                });
                request.end();
            });
        }
    }
}

