/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.definition;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerOperationMeta;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class PojoConsumerMeta {
    private MicroserviceReferenceConfig microserviceReferenceConfig;
    private SchemaMeta schemaMeta;
    private Map<Method, PojoConsumerOperationMeta> operationMetas = new HashMap<Method, PojoConsumerOperationMeta>();

    public PojoConsumerMeta(MicroserviceReferenceConfig microserviceReferenceConfig, SwaggerConsumer swaggerConsumer, SchemaMeta schemaMeta) {
        this.microserviceReferenceConfig = microserviceReferenceConfig;
        this.schemaMeta = schemaMeta;
        SwaggerGenerator intfSwaggerGenerator = SwaggerGenerator.create((Class)swaggerConsumer.getConsumerIntf());
        intfSwaggerGenerator.scanClassAnnotation();
        for (SwaggerConsumerOperation swaggerConsumerOperation : swaggerConsumer.getOperations().values()) {
            String operationId = swaggerConsumerOperation.getSwaggerOperation().getOperationId();
            OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
            OperationGenerator intfOperationGenerator = intfSwaggerGenerator.createOperationGenerator(swaggerConsumerOperation.getConsumerMethod());
            intfOperationGenerator.generateResponse();
            PojoConsumerOperationMeta pojoConsumerOperationMeta = new PojoConsumerOperationMeta(this, operationMeta, swaggerConsumerOperation);
            this.operationMetas.put(swaggerConsumerOperation.getConsumerMethod(), pojoConsumerOperationMeta);
        }
    }

    public MicroserviceReferenceConfig getMicroserviceReferenceConfig() {
        return this.microserviceReferenceConfig;
    }

    public boolean isExpired() {
        return this.microserviceReferenceConfig.isExpired();
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.schemaMeta.getMicroserviceMeta();
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    @VisibleForTesting
    public PojoConsumerOperationMeta findOperationMeta(String consumerMethodName) {
        for (Map.Entry<Method, PojoConsumerOperationMeta> operationMetaEntry : this.operationMetas.entrySet()) {
            if (!operationMetaEntry.getKey().getName().equals(consumerMethodName)) continue;
            return operationMetaEntry.getValue();
        }
        return null;
    }

    public PojoConsumerOperationMeta findOperationMeta(Method consumerMethod) {
        return this.operationMetas.get(consumerMethod);
    }
}

