/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.HttpTransportContext;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;

@FilterMeta(name="rest-server-codec", invocationType={InvocationType.PRODUCER})
public class RestServerCodecFilter
implements Filter {
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(invocation).thenCompose(this::decodeRequest)).thenCompose(arg_0 -> ((FilterNode)nextNode).onFilter(arg_0))).exceptionally(exception -> Exceptions.exceptionToResponse((Invocation)invocation, (Throwable)exception, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR))).thenCompose(response -> this.encodeResponse(invocation, (Response)response));
    }

    protected CompletableFuture<Invocation> decodeRequest(Invocation invocation) {
        HttpTransportContext transportContext = (HttpTransportContext)invocation.getTransportContext();
        HttpServletRequestEx requestEx = transportContext.getRequestEx();
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        Map<String, Object> swaggerArguments = RestCodec.restToArgs((HttpServletRequest)requestEx, restOperationMeta);
        invocation.setSwaggerArguments(swaggerArguments);
        return CompletableFuture.completedFuture(invocation);
    }

    protected CompletableFuture<Response> encodeResponse(Invocation invocation, Response response) {
        invocation.onEncodeResponseStart(response);
        HttpTransportContext transportContext = (HttpTransportContext)invocation.getTransportContext();
        ProduceProcessor produceProcessor = transportContext.getProduceProcessor();
        HttpServletResponseEx responseEx = transportContext.getResponseEx();
        boolean download = RestServerCodecFilter.isDownloadFileResponseType(invocation, response);
        return RestServerCodecFilter.encodeResponse(response, download, produceProcessor, responseEx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompletableFuture<Response> encodeResponse(Response response, boolean download, ProduceProcessor produceProcessor, HttpServletResponseEx responseEx) {
        responseEx.setStatus(response.getStatusCode(), response.getReasonPhrase());
        RestServerCodecFilter.copyHeadersToHttpResponse(response.getHeaders().getHeaderMap(), responseEx);
        if (download) {
            return CompletableFuture.completedFuture(response);
        }
        responseEx.setContentType(produceProcessor.getName() + "; charset=utf-8");
        try (BufferOutputStream output = new BufferOutputStream((ByteBuf)Unpooled.compositeBuffer());){
            produceProcessor.encodeResponse((OutputStream)output, response.getResult());
            responseEx.setBodyBuffer(output.getBuffer());
            CompletableFuture<Response> completableFuture = CompletableFuture.completedFuture(response);
            return completableFuture;
        }
        catch (Throwable e) {
            return AsyncUtils.completeExceptionally((Throwable)e);
        }
    }

    public static boolean isDownloadFileResponseType(Invocation invocation, Response response) {
        return Part.class.isAssignableFrom(invocation.findResponseType(response.getStatusCode()).getRawClass());
    }

    public static void copyHeadersToHttpResponse(Map<String, List<Object>> headerMap, HttpServletResponseEx responseEx) {
        if (headerMap == null) {
            return;
        }
        for (Map.Entry<String, List<Object>> entry : headerMap.entrySet()) {
            for (Object value : entry.getValue()) {
                if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Transfer-Encoding")) continue;
                responseEx.addHeader(entry.getKey(), String.valueOf(value));
            }
        }
    }
}

