/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.streams.WriteStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Part;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.foundation.common.utils.PartUtils;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.foundation.vertx.stream.PumpFromPart;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientRequestImpl
implements RestClientRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientRequestImpl.class);
    protected Context context;
    protected AsyncResponse asyncResp;
    private final Multimap<String, Part> uploads = ArrayListMultimap.create();
    protected HttpClientRequest request;
    protected Map<String, String> cookieMap;
    protected Map<String, Object> formMap;
    protected Buffer bodyBuffer;
    private Handler<Throwable> throwableHandler;

    public RestClientRequestImpl(HttpClientRequest request, Context context, AsyncResponse asyncResp) {
        this(request, context, asyncResp, null);
    }

    public RestClientRequestImpl(HttpClientRequest request, Context context, AsyncResponse asyncResp, Handler<Throwable> throwableHandler) {
        this.context = context;
        this.asyncResp = asyncResp;
        this.request = request;
        this.throwableHandler = throwableHandler;
    }

    @Override
    public void write(Buffer bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
    }

    @Override
    public Buffer getBodyBuffer() throws Exception {
        this.genBodyBuffer();
        return this.bodyBuffer;
    }

    @Override
    public void attach(String name, Object partOrList) {
        if (null == partOrList) {
            LOGGER.debug("null file is ignored, file name = [{}]", (Object)name);
            return;
        }
        if (partOrList.getClass().isArray()) {
            for (Object part : (Object[])partOrList) {
                this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, (Object)part));
            }
        }
        if (List.class.isAssignableFrom(partOrList.getClass())) {
            for (Object part : (List)partOrList) {
                this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, part));
            }
            return;
        }
        this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, (Object)partOrList));
    }

    @Override
    public void end() {
        this.writeCookies();
        if (!this.uploads.isEmpty()) {
            this.doEndWithUpload();
            return;
        }
        this.doEndNormal();
    }

    protected void doEndWithUpload() {
        this.request.setChunked(true);
        String boundary = "boundary" + UUID.randomUUID().toString();
        this.putHeader("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
        this.genBodyForm(boundary);
        this.attachFiles(boundary);
    }

    private void genBodyForm(String boundary) {
        if (this.formMap == null) {
            return;
        }
        try (BufferOutputStream output = new BufferOutputStream();){
            for (Map.Entry<String, Object> entry : this.formMap.entrySet()) {
                output.write(this.bytesOf("\r\n"));
                output.write(this.bytesOf("--" + boundary + "\r\n"));
                output.write(this.bytesOf("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n"));
                if (entry.getValue() == null) continue;
                String value = RestObjectMapperFactory.getRestObjectMapper().convertToString(entry.getValue());
                output.write(value.getBytes(StandardCharsets.UTF_8));
            }
            this.request.write(output.getBuffer());
        }
        catch (Exception e) {
            this.asyncResp.consumerFail((Throwable)e);
        }
    }

    private byte[] bytesOf(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    protected void doEndNormal() {
        try {
            this.genBodyBuffer();
        }
        catch (Exception e) {
            this.asyncResp.consumerFail((Throwable)e);
            return;
        }
        if (this.bodyBuffer == null) {
            this.request.end();
            return;
        }
        this.request.end(this.bodyBuffer);
    }

    private void attachFiles(String boundary) {
        Iterator<Map.Entry<String, Part>> uploadsIterator = this.uploads.entries().iterator();
        this.attachFile(boundary, uploadsIterator);
    }

    private void attachFile(String boundary, Iterator<Map.Entry<String, Part>> uploadsIterator) {
        if (!uploadsIterator.hasNext()) {
            this.request.write(this.boundaryEndInfo(boundary));
            this.request.end();
            return;
        }
        Map.Entry<String, Part> entry = uploadsIterator.next();
        String name = entry.getKey();
        Part part = entry.getValue();
        String filename = part.getSubmittedFileName();
        Buffer fileHeader = this.fileBoundaryInfo(boundary, name, part);
        this.request.write(fileHeader);
        new PumpFromPart(this.context, part).toWriteStream((WriteStream)this.request, this.throwableHandler).whenComplete((v, e) -> {
            if (e != null) {
                LOGGER.debug("Failed to sending file [{}:{}].", new Object[]{name, filename, e});
                this.asyncResp.consumerFail(e);
                return;
            }
            LOGGER.debug("finish sending file [{}:{}].", (Object)name, (Object)filename);
            this.attachFile(boundary, uploadsIterator);
        });
    }

    private Buffer boundaryEndInfo(String boundary) {
        return Buffer.buffer().appendString("\r\n").appendString("--" + boundary + "--\r\n");
    }

    protected Buffer fileBoundaryInfo(String boundary, String name, Part part) {
        Buffer buffer = Buffer.buffer();
        buffer.appendString("\r\n");
        buffer.appendString("--" + boundary + "\r\n");
        buffer.appendString("Content-Disposition: form-data; name=\"").appendString(name).appendString("\"; filename=\"").appendString(part.getSubmittedFileName() != null ? part.getSubmittedFileName() : "null").appendString("\"\r\n");
        buffer.appendString("Content-Type: ").appendString(part.getContentType()).appendString("\r\n");
        buffer.appendString("Content-Transfer-Encoding: binary\r\n");
        buffer.appendString("\r\n");
        return buffer;
    }

    private void genBodyBuffer() throws Exception {
        if (this.bodyBuffer != null) {
            return;
        }
        if (this.formMap == null) {
            return;
        }
        this.request.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/x-www-form-urlencoded");
        try (BufferOutputStream output = new BufferOutputStream();){
            for (Map.Entry<String, Object> entry : this.formMap.entrySet()) {
                output.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
                output.write(61);
                if (entry.getValue() != null) {
                    String value = RestObjectMapperFactory.getRestObjectMapper().convertToString(entry.getValue());
                    value = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                    output.write(value.getBytes(StandardCharsets.UTF_8));
                }
                output.write(38);
            }
            this.bodyBuffer = output.getBuffer();
        }
    }

    private void writeCookies() {
        if (this.cookieMap == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.cookieMap.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append("; ");
        }
        this.request.putHeader(HttpHeaders.COOKIE, (CharSequence)builder.toString());
    }

    public Context getContext() {
        return this.context;
    }

    public HttpClientRequest getRequest() {
        return this.request;
    }

    public Map<String, String> getCookieMap() {
        return this.cookieMap;
    }

    public Map<String, Object> getFormMap() {
        return this.formMap;
    }

    @Override
    public void addCookie(String name, String value) {
        if (this.cookieMap == null) {
            this.cookieMap = new HashMap<String, String>();
        }
        this.cookieMap.put(name, value);
    }

    @Override
    public void addForm(String name, Object value) {
        if (this.formMap == null) {
            this.formMap = new HashMap<String, Object>();
        }
        if (value != null) {
            this.formMap.put(name, value);
        }
    }

    @Override
    public void putHeader(String name, String value) {
        this.request.putHeader(name, value);
    }

    @Override
    public MultiMap getHeaders() {
        return this.request.headers();
    }
}

