/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.auth;

import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.foundation.common.concurrency.SuppressedRunnableWrapper;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.TimeUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.api.request.RbacTokenRequest;
import org.apache.servicecomb.serviceregistry.api.response.RbacTokenResponse;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenCacheManager.class);
    private static final TokenCacheManager INSTANCE = new TokenCacheManager();
    private Clock clock = TimeUtils.getSystemDefaultZoneClock();
    private ScheduledExecutorService tokenCacheWorker = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private final AtomicInteger threadIndexer = new AtomicInteger();

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            Thread thread = new Thread(r, "auth-token-cache-" + this.threadIndexer.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private Map<String, TokenCache> tokenCacheMap = new ConcurrentHashMapEx();

    public static TokenCacheManager getInstance() {
        return INSTANCE;
    }

    private TokenCacheManager() {
    }

    public void addTokenCache(String registryName, String accountName, String password, Cipher cipher) {
        Objects.requireNonNull(registryName, "registryName should not be null!");
        if (this.tokenCacheMap.containsKey(registryName)) {
            LOGGER.warn("duplicate token cache registration for serviceRegistry[{}]", (Object)registryName);
            return;
        }
        TokenCache tokenCache = new TokenCache(registryName, accountName, password, cipher, this.clock);
        tokenCache.setTokenCacheWorker(this.tokenCacheWorker);
        this.tokenCacheMap.put(registryName, tokenCache);
        HttpClients.load();
        RegistryUtils.init();
        tokenCache.refreshToken();
    }

    public String getToken(String registryName) {
        return Optional.ofNullable(this.tokenCacheMap.get(registryName)).map(TokenCache::getToken).orElse("");
    }

    public static class TokenCache {
        private final String registryName;
        private final String accountName;
        private final String password;
        private final Clock clock;
        private String token;
        private long nextRefreshTime;
        private long tokenLife = TimeUnit.MINUTES.toMillis(28L);
        private ScheduledExecutorService tokenCacheWorker;
        private Cipher cipher;

        public TokenCache(String registryName, String accountName, String password, Cipher cipher, Clock clock) {
            this.registryName = registryName;
            this.accountName = accountName;
            this.password = password;
            this.cipher = cipher;
            this.clock = clock;
        }

        public String getToken() {
            return this.token == null ? "" : this.token;
        }

        public void setTokenCacheWorker(ScheduledExecutorService tokenCacheWorker) {
            Objects.requireNonNull(tokenCacheWorker, "input tokenCacheWorker is null");
            if (this.tokenCacheWorker != null) {
                throw new IllegalStateException("tokenCacheWorker already set!");
            }
            this.tokenCacheWorker = tokenCacheWorker;
            this.startTokenRefreshTask();
        }

        private void startTokenRefreshTask() {
            this.tokenCacheWorker.scheduleAtFixedRate((Runnable)new SuppressedRunnableWrapper(() -> {
                if (this.isTokenOutdated()) {
                    this.refreshToken();
                }
            }), 1L, 5L, TimeUnit.SECONDS);
        }

        private boolean isTokenOutdated() {
            return this.clock.millis() > this.nextRefreshTime;
        }

        private void refreshToken() {
            ServiceRegistryClient serviceRegistryClient;
            ServiceRegistry serviceRegistry = RegistryUtils.getServiceRegistry(this.registryName);
            ServiceRegistryClient serviceRegistryClient2 = serviceRegistryClient = serviceRegistry == null ? null : serviceRegistry.getServiceRegistryClient();
            if ((serviceRegistry == null || serviceRegistryClient == null) && "Default".equals(this.registryName)) {
                LOGGER.error("failed to get default serviceRegistry");
                this.tokenCacheWorker.schedule(this::refreshToken, 1L, TimeUnit.SECONDS);
                return;
            }
            RbacTokenRequest request = new RbacTokenRequest();
            request.setAccountName(new String(this.cipher.decrypt(this.accountName.toCharArray())));
            request.setPassword(new String(this.cipher.decrypt(this.password.toCharArray())));
            RbacTokenResponse rbacTokenResponse = serviceRegistryClient.getRbacToken(request);
            LOGGER.info("refresh token successfully {}", (Object)rbacTokenResponse.getStatusCode());
            if (StringUtils.isEmpty((CharSequence)this.token)) {
                if (Response.Status.UNAUTHORIZED.getStatusCode() == rbacTokenResponse.getStatusCode()) {
                    LOGGER.warn("username or password may be wrong!");
                    this.tokenCacheWorker.shutdown();
                } else if (Response.Status.NOT_FOUND.getStatusCode() == rbacTokenResponse.getStatusCode()) {
                    LOGGER.warn("service center do not support rbac token, you should not config account info");
                    this.tokenCacheWorker.shutdown();
                }
            }
            this.token = rbacTokenResponse.getToken();
            this.nextRefreshTime = this.clock.millis() + this.tokenLife;
        }
    }
}

