/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps.strategy;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.qps.strategy.AbstractQpsStrategy;

public class LeakyBucketStrategy
extends AbstractQpsStrategy {
    private volatile AtomicLong requestCount = new AtomicLong();
    private volatile long lastTime;
    private long remainder = 0L;
    private static final String STRATEGY_NAME = "LeakyBucket";

    @Override
    public boolean isLimitNewRequest() {
        if (this.getQpsLimit() == null) {
            this.setQpsLimit(Long.MAX_VALUE);
        }
        if (this.getBucketLimit() == null) {
            this.setBucketLimit(this.getQpsLimit() <= 0x3FFFFFFFFFFFFFFFL ? this.getQpsLimit() * 2L : this.getQpsLimit());
        }
        long nowTime = System.currentTimeMillis();
        long leakCount = (nowTime - this.lastTime + this.remainder) / 1000L * this.getQpsLimit();
        this.remainder = (nowTime - this.lastTime + this.remainder) % 1000L;
        if (this.requestCount.longValue() > leakCount) {
            this.requestCount.addAndGet(-leakCount);
        } else {
            this.requestCount.set(0L);
        }
        this.lastTime = nowTime;
        if (this.requestCount.longValue() < this.getBucketLimit()) {
            this.requestCount.incrementAndGet();
            return false;
        }
        return true;
    }

    @Override
    public String name() {
        return STRATEGY_NAME;
    }
}

